(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    176945,       5449]*)
(*NotebookOutlinePosition[    178125,       5486]*)
(*  CellTagsIndexPosition[    178081,       5482]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Integral de Riemann", "Title",
  PageBreakBelow->False],

Cell[TextData[{
  "\nUniversidad de Granada\nDepartamento de An\[AAcute]lisis \
Matem\[AAcute]tico\nFco. Javier P\[EAcute]rez Gonz\[AAcute]lez  ",
  ButtonBox[" fjperez@ugr.es\n",
    ButtonData:>{
      URL[ "mailto:fjperez@ugr.es"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  PageBreakBelow->False,
  TextAlignment->Right,
  LineSpacing->{0.4, 0},
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell["Un poco de historia", "Section"],

Cell[TextData[{
  "El c\[AAcute]lculo integral tiene sus or\[IAcute]genes en problemas de ",
  StyleBox["cuadraturas ",
    FontSlant->"Italic"],
  "en los que se trataba de calcular \[AAcute]reas de regiones planas \
limitadas por una o varias curvas. Se atribuye a Eudoxo (ca. 370 A.C.) la \
invenci\[OAcute]n del m\[EAcute]todo de ",
  StyleBox["exhausci\[OAcute]n,",
    FontSlant->"Italic"],
  " una t\[EAcute]cnica para calcular el \[AAcute]rea de una regi\[OAcute]n \
aproxim\[AAcute]ndola por una sucesi\[OAcute]n de pol\[IAcute]gonos de forma \
que en cada paso se mejorara la aproximaci\[OAcute]n anterior. \
Arqu\[IAcute]mides (287-212 A.C.) perfeccion\[OAcute] este m\[EAcute]todo y, \
entre otros resultados, calcul\[OAcute] el \[AAcute]rea de un segmento de par\
\[AAcute]bola y el volumen de un segmento de  paraboloide, as\[IAcute] como \
el \[AAcute]rea y el volumen de una esfera. \nSorprende que, siendo tan \
antiguos sus or\[IAcute]genes, la primera definici\[OAcute]n \
matem\[AAcute]tica de integral no fuera dada hasta el siglo XIX por Augustin \
Louis Cauchy (1789-1857). Una posible explicaci\[OAcute]n es que, durante los \
siglos XVII y XVIII, la integraci\[OAcute]n fue considerada como la operaci\
\[OAcute]n inversa de la derivaci\[OAcute]n; el c\[AAcute]lculo integral \
consist\[IAcute]a esencialmente en el c\[AAcute]lculo de primitivas. \
Naturalmente, se conoc\[IAcute]a la utilidad de las integrales para calcular \
\[AAcute]reas y vol\[UAcute]menes, pero los matem\[AAcute]ticos de la \
\[EAcute]poca consideraban estas nociones como dadas de forma intuitiva y no \
vieron la necesidad de precisar su significaci\[OAcute]n matem\[AAcute]tica. \
Los trabajos de Joseph Fourier (1768-1830) sobre representaci\[OAcute]n de \
funciones por series trigonom\[EAcute]tricas hicieron que el concepto de \
funci\[OAcute]n evolucionara, desde la idea restrictiva de funci\[OAcute]n \
como ",
  StyleBox["f\[OAcute]rmula,",
    FontSlant->"Italic"],
  " hasta la definici\[OAcute]n moderna de funci\[OAcute]n dada por Dirichlet \
en 1837. Para entender el significado de la integral de estas nuevas \
funciones m\[AAcute]s generales se vio la necesidad de precisar \
matem\[AAcute]ticamente los conceptos de \[AAcute]rea y de volumen. La \
originalidad de Cauchy es que uni\[OAcute] dos ideas, la de l\[IAcute]mite y \
la de \[AAcute]rea, para dar una definici\[OAcute]n matem\[AAcute]tica de \
integral. Poco despu\[EAcute]s Georg F.B. Riemann (1826-1866) generaliz\
\[OAcute] la definici\[OAcute]n de integral dada por Cauchy. La \
teor\[IAcute]a de la integral de Riemann fue un avance importante pero \
insuficiente. Hubo que esperar hasta el siglo XX para que Henri Lebesgue \
(1875-1941) estableciera en su libro ",
  StyleBox["Le\[CCedilla]ons sur l'int\[EAcute]gration et la \
recherch\[EAcute] des fonctions primitives",
    PageWidth->WindowWidth,
    CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
    CellSize->{726, Inherited},
    FontSlant->"Italic"],
  StyleBox[" (1904) los fundamentos de una ",
    PageWidth->WindowWidth,
    CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
    CellSize->{726, Inherited}],
  " teor\[IAcute]a satisfactoria de la integraci\[OAcute]n. \nLa integraci\
\[OAcute]n es una de las herramientas m\[AAcute]s vers\[AAcute]tiles del C\
\[AAcute]lculo, sus aplicaciones no se limitan a calcular \[AAcute]reas de \
regiones planas o vol\[UAcute]menes de s\[OAcute]lidos, tambi\[EAcute]n se \
utiliza para calcular longitudes de curvas, centros de masas, momentos de \
inercia, \[AAcute]reas de superficies, para representar magnitudes \
f\[IAcute]sicas como el trabajo, la fuerza ejercida por una presi\[OAcute]n, \
o la energ\[IAcute]a potencial en un campo de fuerzas. Puede decirse que la \
integraci\[OAcute]n es la herramienta por excelencia para ",
  StyleBox["medir",
    FontSlant->"Italic"],
  "; de hecho, las modernas teor\[IAcute]as de la integral se llaman ",
  StyleBox["teor\[IAcute]as de la medida",
    FontSlant->"Italic"],
  " y constituyen el fundamento de ramas de la Matem\[AAcute]tica como el C\
\[AAcute]lculo de Probabilidades y la Estad\[IAcute]stica. \nEn este curso \
vamos a estudiar la integraci\[OAcute]n desde un punto de vista esencialmente \
pr\[AAcute]ctico, evitando largos desarrollos te\[OAcute]ricos. Nos interesa \
la integral como herramienta de c\[AAcute]lculo. El curso pr\[OAcute]ximo \
cuando estudies la integral y la medida de Lebesgue ver\[AAcute]s que la \
integraci\[OAcute]n es la herramienta te\[OAcute]rica indispensable para \
obtener algunos de los resultados m\[AAcute]s profundos del An\[AAcute]lisis \
Matem\[AAcute]tico."
}], "Text",
  CellMargins->{{Inherited, 0}, {Inherited, Inherited}},
  CellSize->{726, Inherited},
  FontFamily->"Times New Roman",
  FontSize->14],

Cell[TextData[StyleBox["Para trabajar en este cuaderno debes evaluar primero \
( Kernel -> Evaluation -> Evaluate Initialization )  las celdas de \
inicializaci\[OAcute]n que siguen.  ",
  FontSize->14]], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section",
  InitializationCell->True],

Cell[BoxData[
    \(\(<< Graphics`FilledPlot`;\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(graford[func_, {var_, xmin_, xmax_}, opts___] := 
        FilledPlot[func, {var, xmin, xmax}, 
          Fills \[Rule] {RGBColor[1, 1, 0]}, 
          AxesOrigin \[Rule] {Max[xmin -  .2, 0], 0}\ , 
          Epilog -> {Line[{{Max[xmin -  .2, 0], 0}, {xmax +  .2, 0}}], 
              Line[{{xmin, 0}, {xmin, func /. var \[Rule] xmin}}], 
              Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}]}, 
          opts];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(areasup[func_, {var_, xmin_, xmax_, sub_}, opts___] := 
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = area + #  inc; {RGBColor[0, 1, 1], 
                      Rectangle[{n, 0}, {n + inc, #}], GrayLevel[0], 
                      Line[{{n, 0}, {n + inc, 0}, {n + inc, #}, {n, #}, {n, 
                            0}}], RGBColor[1, 0, 0], 
                      Point[{Last[
                            Last[Sort[
                                Transpose[{func /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[
                                      n + j, {j, 0, inc, 
                                        inc/10}]}]]]], #}]})\) &\)[
                Max[func /. 
                    var \[Rule] Table[n + j, {j, 0, inc, inc/10}]]], {n, 
                xmin, xmax - \ inc, inc}]; 
          cotas = {Line[{{xmin, 0}, {xmin, func /. var \[Rule] xmin}}], 
              Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}], 
              Line[{{xmin, 0}, {xmax, 0}}]}; \[IndentingNewLine]graf = 
            FilledPlot[func, \ {var, xmin, xmax}, 
              Fills \[Rule] {RGBColor[1, 1, 0]}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, opts, 
            AxesOrigin \[Rule] {Max[xmin -  .2, 0], 0}, 
            Epilog \[Rule] {PointSize[0.02], rects, 
                Extract[
                  InputForm[
                    graf], {{1, 1, 1, 1, 1, 1}, {1, 1, 2, 1, 2, 1, 1, 
                      1}}]}, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm[
                  If[Min[Table[
                          func /. var \[Rule] n, {n, xmin, xmax - \ inc, 
                            inc}]] \[GreaterEqual] 
                      0, \ "\<\[Lambda](G(f,a,b))\[TildeEqual]\>" <> 
                      ToString[
                        area], \*"\"\<\[Lambda](G(\!\(\(f\^+\)\),a,b))-\
\[Lambda](G(\!\(\(f\^-\)\),a,b))\[TildeEqual]\>\"" <> ToString[area]]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(areainf[func_, {var_, xmin_, xmax_, sub_}, 
          opts___] := \[IndentingNewLine]\t
        Module[{rects, n, graf, inc, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]rects\  = \ 
            Table[\n\t\t\t\t\(\((area = area + #  inc; {RGBColor[0, 1, 1], 
                      Rectangle[{n, 0}, {n + inc, #}], GrayLevel[0], 
                      Line[{{n, 0}, {n + inc, 0}, {n + inc, #}, {n, #}, {n, 
                            0}}], RGBColor[1, 0, 0], 
                      Point[{Last[
                            First[Sort[
                                Transpose[{func /. 
                                      var -> Table[
                                        n + j, {j, 0, inc, inc/10}], 
                                    Table[
                                      n + j, {j, 0, inc, 
                                        inc/10}]}]]]], #}]})\) &\)[
                Min[func /. var \[Rule] {n, n + inc}]], {n, xmin, 
                xmax - \ inc, 
                inc}]; \[IndentingNewLine]\t\tcotas = {Line[{{xmin, 
                    0}, {xmin, func /. var \[Rule] xmin}}], 
              Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}], 
              Line[{{xmin, 0}, {xmax, 0}}]}; \[IndentingNewLine]graf = 
            FilledPlot[func, \ {var, xmin, xmax}, 
              Fills \[Rule] {RGBColor[1, 1, 0]}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, opts, 
            AxesOrigin \[Rule] {Max[xmin -  .2, 0], 0}, 
            Epilog \[Rule] {PointSize[0.02], rects, 
                Extract[
                  InputForm[
                    graf], {{1, 1, 1, 1, 1, 1}, {1, 1, 2, 1, 2, 1, 1, 
                      1}}]}, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm[
                  If[Min[Table[
                          func /. var \[Rule] n, {n, xmin, xmax - \ inc, 
                            inc}]] \[GreaterEqual] 
                      0, \ "\<\[Lambda](G(f,a,b))\[TildeEqual]\>" <> 
                      ToString[
                        area], \*"\"\<\[Lambda](G(\!\(\(f\^+\)\),a,b))-\
\[Lambda](G(\!\(\(f\^-\)\),a,b))\[TildeEqual]\>\"" <> ToString[area]]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(alearea[func_, {var_, xmin_, xmax_, sub_}, 
          opts___] := \[IndentingNewLine]\t
        Module[{rects, n, graf, inc, partalea, cotas, 
            area = 0}, \[IndentingNewLine]inc = 
            N[\((xmax\  - \ xmin)\)/sub]; \[IndentingNewLine]partalea = 
            Sort[Join[
                Table[Random[
                    Real, {xmin\  +  .01, xmax\  - \  .01}], {sub\  - \ 
                      1}], {xmin, 
                  xmax}]]; \[IndentingNewLine]\t\t\trects\  = \ 
            Table[\n\t\t\t\t\(\((area = 
                      area + #\ \ \((partalea[\([n + 1]\)] - 
                              partalea[\([n]\)])\); {RGBColor[0, 1, 1], 
                      Rectangle[{partalea[\([n]\)], 
                          0}, {partalea[\([n + 1]\)], #}], GrayLevel[0], 
                      Line[{{partalea[\([n]\)], 0}, {partalea[\([n + 1]\)], 
                            0}, {partalea[\([n + 
                                  1]\)], #}, {partalea[\([n]\)], #}, \
{partalea[\([n]\)], 0}}], RGBColor[1, 0. , 0. ], 
                      Point[{\((partalea[\([n]\)] + partalea[\([n + 1]\)])\)/
                            2, #}]})\) &\)[
                func /. var \[Rule] \((partalea[\([n]\)] + 
                          partalea[\([n + 1]\)])\)/2], {n, 1, 
                Length[partalea] - 
                  1}]; \[IndentingNewLine]\t\t\tcotas = {Line[{{xmin, 
                    0}, {xmin, func /. var \[Rule] xmin}}], 
              Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}], 
              Line[{{xmin, 0}, {xmax, 0}}]}; \[IndentingNewLine]graf = 
            FilledPlot[func, \ {var, xmin, xmax}, 
              Fills \[Rule] {RGBColor[1, 1, 0]}, 
              DisplayFunction \[Rule] Identity]; \ \[IndentingNewLine]\t
          Show[{graf, Graphics[cotas]}, 
            DisplayFunction \[Rule] $DisplayFunction, opts, 
            AxesOrigin \[Rule] {Max[xmin -  .2, 0], 0}, 
            Epilog \[Rule] {PointSize[0.02], rects, 
                Extract[
                  InputForm[
                    graf], {{1, 1, 1, 1, 1, 1}, {1, 1, 2, 1, 2, 1, 1, 
                      1}}]}, \[IndentingNewLine]PlotLabel\  \[Rule] 
              StyleForm[
                TraditionalForm[
                  If[Min[Table[
                          func /. var \[Rule] n, {n, xmin, xmax - \ inc, 
                            inc}]] \[GreaterEqual] 
                      0, \ "\<\[Lambda](G(f,a,b))\[TildeEqual]\>" <> 
                      ToString[
                        area], \*"\"\<\[Lambda](G(\!\(\(f\^+\)\),a,b))-\
\[Lambda](G(\!\(\(f\^-\)\),a,b))\[TildeEqual]\>\"" <> ToString[area]]], 
                FontSlant \[Rule] "\<Italic\>", 
                FontSize \[Rule] 12]]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(areafunc[func_, {var_, xmin_, xmax_}, n_, {ymin_, ymax_}, opts___] := 
        Do[Off[Do::"\<itflrw\>"]; 
          Show[{Plot[func, {var, xmin, xmax}, DisplayFunction -> Identity], 
              FilledPlot[func, {var, xmin, t}, 
                Fills \[Rule] {RGBColor[1, 1, 0]}, 
                DisplayFunction -> Identity], \[IndentingNewLine]ListPlot[
                Table[{k, NIntegrate[func, {var, xmin, k}]}, {k, xmin, 
                    t, \((xmax - xmin)\)/\((10  n \((t - xmin)\))\)}], 
                PlotStyle \[Rule] {RGBColor[1, 0, 0]}, 
                PlotJoined \[Rule] True, 
                DisplayFunction \[Rule] 
                  Identity], \[IndentingNewLine]Graphics[{Text[
                    x, {Off[Graphics::"\<gptn\>"]; t, 
                      Which[t \[Equal] 
                          xmax, {}, \((func /. 
                              var \[Rule] t)\) \[GreaterEqual] 
                          0, \(-0.1\), \((func /. var \[Rule] t)\) < 0, 
                        0.1]}], \[IndentingNewLine]Line[{{xmin -  .4, 
                        0}, {xmax +  .2, 0}}], \[IndentingNewLine]Text[
                    xmin, {xmin, 
                      Which[xmin \[LessEqual] 
                          0.1, {}, \((func /. \[InvisibleSpace]var \[Rule] 
                                xmin)\) \[GreaterEqual] 
                          0, \(-0.1\), \((func /. var \[Rule] t)\) < 0, 
                        0.1]}], 
                  Text[xmax, {xmax + 0.05, 
                      If[\((func /. \[InvisibleSpace]var \[Rule] 
                                xmax)\) \[GreaterEqual] 0, \(-0.1\), 
                        0.1]}], \[IndentingNewLine]Line[{{xmin, 0}, {xmin, 
                        func /. var \[Rule] xmin}}], 
                  Line[{{xmax, 0}, {xmax, func /. var \[Rule] xmax}}], 
                  Line[{{t, 0}, {t, func /. var \[Rule] t}}]}]}, 
            AxesOrigin -> {Max[xmin -  .3, 0], 0}, opts, 
            DisplayFunction \[Rule] $DisplayFunction, \ 
            Ticks \[Rule] {{}, Automatic}, AxesFront \[Rule] True, 
            PlotRange \[Rule] {{xmin -  .4, xmax +  .2}, {ymin, ymax}}, 
            PlotLabel \[Rule] 
              StyleForm["\<F(x)=\>"\ TraditionalForm[\ 
                    N[Integrate[func, {var, xmin, t}], 6]], 
                FontSize \[Rule] 12]\ ], {t, xmin + \((xmax - xmin)\)/n, 
            xmax, \((xmax - xmin)\)/n}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(logdos := 
        Show[{Plot[1/x, {x,  .5, 3}, DisplayFunction \[Rule] Identity], 
            FilledPlot[1/x, {x, 1, 2}, DisplayFunction \[Rule] Identity, 
              Fills \[Rule] {RGBColor[0, 1, 1]}], 
            Graphics[{Line[{{2, 0}, {2, 1/2}}], Line[{{1, 0}, {1, 1}}], 
                Text["\<y=1/x\>", {1.85, 0.7}], 
                Text[\*"\"\<\!\(\[Integral]\_1\%2\)\!\(1\/x\)dx=log\
\[ThinSpace]2\>\"", {1.5, 0.3}]}]}, 
          PlotRange \[Rule] {{\(- .1\), 3.1}, {\(- .1\), 2}}, 
          DisplayFunction \[Rule] $DisplayFunction, 
          AxesOrigin \[Rule] {0, 0}];\)\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Sumas de Riemann", "Section"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " una funci\[OAcute]n acotada. Representaremos por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(G(f, a, b)\),
          FontSize->16], TraditionalForm]]],
  " la regi\[OAcute]n del plano comprendida entre la curva ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = \ f(x)\),
          FontSize->16], TraditionalForm]]],
  ", el eje de abscisas y las rectas ",
  StyleBox["y=a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y=b",
    FontSlant->"Italic"],
  ". "
}], "Text",
  FontSize->14],

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  "Puedes representar sombreada en gris la regi\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(G(f, a, b)\),
          FontSize->16], TraditionalForm]]],
  " con la orden ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(grafOrd[f[x], {x, a, b}, opts]\),
          FontSize->16], TraditionalForm]]],
  " que admite optciones como \"Plot\". Prueba con distintas funciones."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(graford[1.5 + Sin[x], {x, 1, 7}];\)\)], "Input"],

Cell[BoxData[
    \(\(graford[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8}, Frame \[Rule] True, 
        Background \[Rule] RGBColor[1,  .8,  .87]];\)\)], "Input"],

Cell[TextData[{
  "Nos proponemos calcular el \[AAcute]rea de dicha regi\[OAcute]n. Puesto \
que, en general, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(G(f, a, b)\),
          FontSize->16], TraditionalForm]]],
  " no puede descomponerse en tri\[AAcute]ngulos o rect\[AAcute]ngulos, no \
hay una ",
  StyleBox["f\[OAcute]rmula",
    FontSlant->"Italic"],
  " que nos permita calcular directamente su \[AAcute]rea. En situaciones \
como esta, una estrategia b\[AAcute]sica consiste en obtener ",
  StyleBox["soluciones aproximadas",
    FontSlant->"Italic"],
  " que permitan definir el ",
  StyleBox["valor exacto",
    FontSlant->"Italic"],
  " del \[AAcute]rea como ",
  StyleBox["l\[IAcute]mite",
    FontSlant->"Italic"],
  " de las mismas. F\[IAcute]jate que, al proceder as\[IAcute], estamos ",
  StyleBox["definiendo",
    FontSlant->"Italic"],
  " dicho ",
  StyleBox["valor exacto",
    FontSlant->"Italic"],
  ", es decir, estamos dando una ",
  StyleBox["definici\[OAcute]n matem\[AAcute]tica ",
    FontSlant->"Italic"],
  "del concepto intuitivo de ",
  StyleBox["\[AAcute]rea",
    FontSlant->"Italic"],
  ". Ello trae como consecuencia inevitable que haya regiones ",
  StyleBox["extra\[NTilde]as",
    FontSlant->"Italic"],
  " en el plano que, ",
  StyleBox["seg\[UAcute]n la definici\[OAcute]n dada",
    FontSlant->"Italic"],
  ", no tengan \[AAcute]rea. Naturalmente, queremos que dicha definici\
\[OAcute]n sea lo m\[AAcute]s general posible,",
  StyleBox[" lo que depende del tipo de soluciones aproximadas que elijamos",
    FontSlant->"Italic"],
  ". Las aproximaciones consideradas en la teor\[IAcute]a de la integral de \
Lebesgue conducen a un concepto de \[AAcute]rea muy general que \
tendr\[AAcute]s oportunidad de estudiar el curso pr\[OAcute]ximo. En lo que \
sigue vamos a considerar las aproximaciones que conducen a la integral de \
Riemann. \nLa integral de Riemann, aunque desde un punto de vista \
te\[OAcute]rico no es muy interesante, es una herramienta muy \[UAcute]til \
para calcular y, no lo olvidemos, ese es un objetivo principal en este curso \
de ",
  StyleBox["C\[AAcute]lculo",
    FontSlant->"Italic"],
  ".  \nComo los conceptos que vamos a introducir se interpretan con m\
\[AAcute]s facilidad cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es positiva, es conveniente tener bien presente en lo que sigue el \
siguiente artificio que permite representar cualquier funci\[OAcute]n como \
diferencia de dos funciones positivas."
}], "Text",
  FontSize->14],

Cell["Parte positiva y parte negativa de una funci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Cualquier funci\[OAcute]n  ",
  StyleBox["f  ",
    FontSlant->"Italic"],
  "puede escribirse como diferencia de dos funciones positivas:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x)\), "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                
                StyleBox[\(\(\[VerticalSeparator]\)\(f(
                      x)\)\(\[VerticalSeparator]\)\(\ \)\(+\ \(f(x)\)\)\),
                  FontSize->16], 
                StyleBox["2",
                  FontSize->16]], "-", 
              FractionBox[
                
                StyleBox[\(\(\[VerticalSeparator]\)\(f(
                      x)\)\(\[VerticalSeparator]\)\(\ \)\(-\(f(x)\)\)\),
                  FontSize->16], 
                StyleBox["2",
                  FontSize->16]]}], 
            "=", \(\(f\^\(\(\ \)\(+\)\)\)(x) - \(f\^-\)(x)\)}]}], 
        TraditionalForm]]],
  "\nla funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(f\^+\)(x)\), "=", 
          FractionBox[
            
            StyleBox[\(\(\[VerticalSeparator]\)\(f(
                  x)\)\(\[VerticalSeparator]\)\(\ \)\(+\ \(f(x)\)\)\),
              FontSize->16], 
            StyleBox["2",
              FontSize->16]]}], TraditionalForm]]],
  "se llama ",
  StyleBox["parte positiva",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" de f",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  " y la funci\[OAcute]n  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(f\^-\)(x)\), "=", 
          FractionBox[
            
            StyleBox[\(\(\[VerticalSeparator]\)\(f(
                  x)\)\(\[VerticalSeparator]\)\(-\(f(x)\)\)\),
              FontSize->16], 
            StyleBox["2",
              FontSize->16]]}], TraditionalForm]]],
  " se llama ",
  StyleBox["parte negativa ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["de f. ",
    FontSlant->"Italic"],
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) \[GreaterEqual] 0\)]],
  " se tiene que  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(f\^+\)(x)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^-\)(x) = 0\)]],
  "; mientras que si  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) \[LessEqual] 0\)]],
  " se tiene que  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(-\(\(f\^-\)(x)\)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^+\)(x) = 0\)]],
  ". F\[IAcute]jate que, a pesar de su nombre y de la forma en que se \
simboliza, la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^-\)\)]],
  StyleBox["es una funci\[OAcute]n positiva",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n es consecuencia de las definiciones dadas que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(f(x)\)\(|\)\) = \(f\^+\)(x) + \(f\^-\)(
            x)\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(f\)\(|\)\) = \(f\^+\) + \(f\^-\)\)]],
  ".\nPuedes representar simult\[AAcute]neamente las gr\[AAcute]ficas de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^+\), \ \(f\^-\)\)]],
  " y ",
  Cell[BoxData[
      FormBox[
        FormBox[\(\(\ \)\(\(|\)\(f\)\(|\)\)\),
          "TraditionalForm"], TraditionalForm]]],
  " con la orden \"Show[graficas, opciones]\". Para ello conviene que \
especifiques, con la opci\[OAcute]n \"PlotRange->{ymin,ymax}\", un intervalo \
com\[UAcute]n del eje de ordenadas donde se representar\[AAcute]n las gr\
\[AAcute]ficas. Experimenta con distintas funciones. "
}], "Text",
  FontSize->16],

Cell[BoxData[{
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := Sin[x]\ Exp[\(-x\)/17];\)\), "\[IndentingNewLine]", 
    \(\(Show[{graford[f[x], {x, 0, 14}, PlotRange -> {\(- .8\), 1}], 
          graford[\((Abs[f[x]] + f[x])\)/2, {x, 0, 14}, 
            PlotRange -> {\(- .8\), 
                1}], \[IndentingNewLine]graford[\((Abs[f[x]] - f[x])\)/2, {x, 
              0, 14}, PlotRange -> {\(- .8\), 1}], 
          graford[Abs[f[x]], {x, 0, 14}, PlotRange -> {\(- .8\), 1}]}, 
        DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f];\)\)}], "Input"],

Cell[TextData[{
  "En lo que sigue, representaremos el valor exacto (que a\[UAcute]n no hemos \
definido) del \[AAcute]rea de la regi\[OAcute]n",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            FormBox[\(G(f, a, b)\),
              "TraditionalForm"]}],
          FontSize->16], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](G(f, a, b))\)],
    FontSize->16],
  ", (la letra \"\[Lambda]\" alude a la inicial de \"Lebesgue\"). \nEn la \
integral de Riemann, el \[AAcute]rea buscada se aproxima por \
rect\[AAcute]ngulos de la siguiente forma. Primero, se divide el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  " en un n\[UAcute]mero finito de subintervalos ",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          FormBox[\(x\_\(k - 1\), x\_k\),
            "TraditionalForm"], "]"}], TraditionalForm]],
    FontSize->16],
  StyleBox[", ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] \ k \[LessEqual] \ n\)],
    FontSize->16],
  ", cuyas longitudes pueden ser distintas y con la \[UAcute]nica condici\
\[OAcute]n de que no se solapen:  ",
  Cell[BoxData[
      \(TraditionalForm\`a = \(\(x\_0 < x\_1 < x\_2 < \  ... \)\  < 
            x\_\(n - 1\) < x\_n = b\)\)],
    FontSize->16],
  "; se dice que estos puntos constituyen una ",
  StyleBox["partici\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  ". A continuaci\[OAcute]n se elige en cada subintervalo un punto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t\_k \[Element] \([x\_\(k - 1\), x\_k]\)\),
          FontSize->16], TraditionalForm]]],
  ", y se forma el rect\[AAcute]ngulo cuya base es el intervalo ",
  StyleBox["[",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`x\_\(k - 1\), x\_k\)],
    FontSize->16],
  StyleBox["]",
    FontSize->16],
  " y altura igual a ",
  Cell[BoxData[
      \(TraditionalForm\`f(t\_k)\)],
    FontSize->16],
  ". Dicho rect\[AAcute]ngulo est\[AAcute] en el semiplano superior si ",
  Cell[BoxData[
      \(TraditionalForm\`f(t\_k) \[GreaterEqual] 0\)]],
  " y en el semiplano inferior si ",
  Cell[BoxData[
      \(TraditionalForm\`f(t\_k) < 0\)]],
  ". Finalmente se forma la suma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%n\( f(
            t\_k)\) \((x\_k - x\_\(k - 1\))\)\)]],
  ".  "
}], "Text",
  FontSize->16],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Dada una partici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(P = {x\_0 = a, \ x\_1, \ x\_2,  ... , \ x\_\(n - 1\), 
              x\_n = b}\),
          FontSize->16], TraditionalForm]]],
  " del intervalo ",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  ", y un punto",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`t\_k \[Element] \([x\_\(k - 1\), x\_k]\)\)],
    FontSize->16],
  " en cada uno de los intervalos de la misma, el n\[UAcute]mero\n\t\t\t\t\t\
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(\[Sigma](f, P)\)\(=\)\),
            "TraditionalForm"], 
          
          FormBox[\(\[Sum]\+\(k = 1\)\%n\( f(
                  t\_k)\) \((x\_k - x\_\(k - 1\))\)\),
            "TraditionalForm"]}], TraditionalForm]],
    FontSize->18],
  "\nse llama ",
  StyleBox["una",
    FontSlant->"Italic"],
  " ",
  StyleBox["suma de Riemann",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " para la partici\[OAcute]n ",
  StyleBox["P",
    FontSlant->"Italic"],
  "."
}], "Text",
  FontSize->14],

Cell["Observaciones", "Subsection"],

Cell[TextData[{
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " F\[IAcute]jate que, como hay libertad para elegir los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k \[Element] \([x\_\(k - 1\), x\_k]\)\)],
    FontSize->16],
  ",  para cada partici\[OAcute]n hay infinitas sumas de Riemann.\n",
  StyleBox["\[FilledSmallCircle] ",
    FontWeight->"Bold"],
  "Cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es positiva,",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(\(\[Sigma](f, P)\)\(\ \)\),
            "TraditionalForm"]}], TraditionalForm]]],
  "es una aproximaci\[OAcute]n del \[AAcute]rea de la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(f, a, b)\)],
    FontSize->16],
  ". Simb\[OAcute]licamente ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Lambda](
          G(f, a, b))\)\(\[TildeEqual]\)\(\[Sigma](f, P)\)\(\ \)\)\)]],
  ".",
  StyleBox["\n\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " Cuando la funci\[OAcute]n  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  toma valores positivos y negativos podemos escribir:\n",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%n\( f(
              t\_k)\) \((x\_k - 
                x\_\(k - 1\))\) = \(\[Sum]\+\(k = 1\)\%n\((\(f\^+\)(
                    t\_k) - \(f\^-\)(t\_k))\) \((x\_k - 
                  x\_\(k - 1\))\) = \[Sum]\+\(k = 1\)\%n\(\( f\^+\)(
                  t\_k)\) \((x\_k - 
                    x\_\(k - 1\))\) - \[Sum]\+\(k = 1\)\%n\(\( f\^-\)(
                  t\_k)\) \((x\_k - x\_\(k - 1\))\)\)\)]],
  ".\nEn este caso,",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Sigma](f, P)\)\)\)]],
  " es una aproximaci\[OAcute]n del \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`G(\(f\^+\), a, b)\)],
    FontSize->16],
  " ",
  StyleBox["menos",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " el \[AAcute]rea de ",
  Cell[BoxData[
      \(TraditionalForm\`G(\(f\^-\), a, b)\)],
    FontSize->16],
  ". Simb\[OAcute]licamente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma](f, 
          P) \[TildeEqual] \[Lambda](
            G(f\^\(\(\ \)\(+\)\), a, b)) - \ \[Lambda](
            G(\(f\^-\), a, b))\)]],
  "."
}], "Text",
  FontSize->16],

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  "La funci\[OAcute]n",
  StyleBox[" \"", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`alearea[f, {x, a, b, n}]\)],
    FontSize->16],
  "\" elige ",
  StyleBox["aleatoriamente",
    FontSlant->"Italic"],
  " una partici\[OAcute]n de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  " con ",
  StyleBox["n",
    FontSlant->"Italic"],
  " subintervalos, en cada uno de ellos elige como valor de",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`t\_k\)],
    FontSize->16],
  " su punto medio, dibuja la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y representa, en azul, los rect\[AAcute]ngulos cuya base es el \
subintervalo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            RowBox[{"[", 
              FormBox[\(x\_\(k - 1\), x\_k\),
                "TraditionalForm"], "]"}],
            FontSize->16], " "}], TraditionalForm]]],
  "y altura igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(t\_k)\),
          FontSize->16], TraditionalForm]]],
  " y, en rojo, los puntos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\((t\_k, f(t\_k))\),
          FontSize->16], TraditionalForm]]],
  ". Finalmente, calcula la suma de Riemann correspondiente. Observa que las \
bases de los rect\[AAcute]ngulos pueden ser muy distintas entre s\[IAcute]. \
Tambi\[EAcute]n puedes comprobar que si ejecutas varias veces el comando, sin \
cambiar nada en \[EAcute]l, obtendr\[AAcute]s resultados distintos porque \
cambiar\[AAcute] la partici\[OAcute]n elegida."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(alearea[1.5 + Sin[x], {x, 1, 7, 14}];\)\)], "Input"],

Cell[BoxData[
    \(\(alearea[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8, 16}];\)\)], "Input"],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Dada una partici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(P = {x\_0 = a, \ x\_1, \ x\_2,  ... , \ x\_\(n - 1\), 
              x\_n = b}\),
          FontSize->16], TraditionalForm]]],
  " del intervalo  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\([a, b]\),
          FontSize->16], TraditionalForm]]],
  ", definamos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(M\_k = sup\ f[x\_\(k - 1\), x\_k]\),
          FontSize->16], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`m\_k = inf\ f[x\_\(k - 1\), x\_k]\)],
    FontSize->16],
  ". Los n\[UAcute]meros\n\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(S(f, P)\)\(=\)\),
            "TraditionalForm"], 
          FormBox[\(\[Sum]\+\(k = 1\)\%n\( M\_k\)(x\_k - x\_\(k - 1\))\),
            "TraditionalForm"]}], TraditionalForm]],
    FontSize->18,
    Background->None],
  StyleBox[",  ",
    FontSize->18],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(I(f, P)\)\(=\)\),
            "TraditionalForm"], 
          FormBox[\(\[Sum]\+\(k = 1\)\%n\( m\_k\)(x\_k - x\_\(k - 1\))\),
            "TraditionalForm"]}], TraditionalForm]],
    FontSize->18],
  "\nse llaman, respectivamente, ",
  StyleBox["suma superior",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y ",
  StyleBox["suma inferior",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " para la partici\[OAcute]n ",
  StyleBox["P",
    FontSlant->"Italic"],
  ".  Es para definir estas sumas para lo que se precisa que ",
  StyleBox["f",
    FontSlant->"Italic"],
  " est\[EAcute] acotada en  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\([a, b]\),
          FontSize->16], TraditionalForm]]],
  ".\nPuesto que para todo",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`t\_k \[Element] \([x\_\(k - 1\), x\_k]\)\)],
    FontSize->16],
  " es ",
  Cell[BoxData[
      \(TraditionalForm\`m\_k \[LessEqual] f(t\_k) \[LessEqual] M\_k\)],
    FontSize->16],
  ", deducimos que para toda suma de Riemann, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Sigma](f, \ P)\)\(\ \)\(,\)\)\)],
    FontSize->16],
  " de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  para la partici\[OAcute]n ",
  StyleBox["P",
    FontSlant->"Italic"],
  " se cumple que  ",
  Cell[BoxData[
      \(TraditionalForm\`I(f, P) \[LessEqual] \[Sigma](f, P) \[LessEqual] 
        S(f, P)\)],
    FontSize->16],
  "."
}], "Text",
  FontSize->14],

Cell["Observaciones", "Subsection"],

Cell[TextData[{
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " Para cada partici\[OAcute]n hay una \[UAcute]nica suma superior y otra \
inferior.\n",
  StyleBox["\[FilledSmallCircle] ",
    FontWeight->"Bold"],
  "Cuando ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es positiva ",
  Cell[BoxData[
      \(TraditionalForm\`S(f, P)\)]],
  " es un valor aproximado por exceso de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](G(f, a, b))\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`I(f, P)\)]],
  " es un valor aproximado por defecto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](G(f, a, b))\)]],
  ".\n",
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " Cuando la funci\[OAcute]n  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  toma valores positivos y negativos ",
  Cell[BoxData[
      \(TraditionalForm\`S(f, P)\)]],
  " es un valor aproximado por exceso de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](G(\(f\^+\), a, b)) - \[Lambda](
          G(\(f\^-\), a, b))\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`I(f, P)\)]],
  " es un valor aproximado por defecto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](G(\(f\^+\), a, b)) - \[Lambda](
          G(\(f\^-\), a, b))\)]],
  "."
}], "Text",
  FontSize->16],

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  "La funci\[OAcute]n",
  StyleBox[" \"", "InlineFormula"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(areasup[f, {x, a, b, n}, \ opts]\),
          FontSize->16], TraditionalForm]]],
  "\" (que tiene opciones como \"Show\") divide el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  " en  ",
  StyleBox["n",
    FontSlant->"Italic"],
  " subintervalos de igual longitud, en cada uno de ellos calcula de forma \
\"casi exacta\" un punto ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k\)],
    FontSize->16],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`f(t\_k) = M\_k\)],
    FontSize->16],
  ", dibuja la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y representa, en azul, los rect\[AAcute]ngulos cuya base es el \
subintervalo ",
  StyleBox["[",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`x\_\(k - 1\), x\_k\)],
    FontSize->16],
  StyleBox["]",
    FontSize->16],
  " y altura igual a ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["M",
            FontSize->16], "k"], TraditionalForm]]],
  " y, en rojo, los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((t\_k, f(t\_k))\)\)],
    FontSize->16],
  ". Finalmente, calcula la suma superior correspondiente. "
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(areasup[1.5 + Sin[x], {x, 1, 7, 12}];\)\)], "Input"],

Cell[BoxData[
    \(\(areasup[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8, 14}];\)\)], "Input"],

Cell[TextData[{
  "Significado an\[AAcute]logo tiene la funci\[OAcute]n ",
  StyleBox["\"", "InlineFormula"],
  Cell[BoxData[
      \(TraditionalForm\`areainf[f, {x, a, b, n}, \ opts]\)],
    FontSize->16],
  "\"."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(areainf[1.5 + Sin[x], {x, 1, 7, 14}];\)\)], "Input"],

Cell[BoxData[
    \(\(areainf[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8, 16}];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Definici\[OAcute]n y propiedades b\[AAcute]sicas de la integral", \
"Section"],

Cell[TextData[{
  "Supongamos que ",
  StyleBox["la funci\[OAcute]n f es positiva",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\([a, b]\)\(\ \)\),
          FontSize->16], TraditionalForm]]],
  ". Es claro que, en tal caso, el valor exacto del \[AAcute]rea de la regi\
\[OAcute]n",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            FormBox[\(G(f, a, b)\),
              "TraditionalForm"]}],
          FontSize->16], TraditionalForm]]],
  ",  debe verificar que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(I(f, P) \[LessEqual] \[Lambda](
          G(f, a, b)) \[LessEqual] S(f, P)\)\)\)],
    FontSize->16],
  " para toda partici\[OAcute]n ",
  StyleBox["P",
    FontSlant->"Italic"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  ". Tenemos, en consecuencia, ",
  StyleBox["DOS",
    FontSlant->"Italic"],
  " candidatos para  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Lambda](G(f, a, b))\),
          FontSize->16], TraditionalForm]]],
  ", a saber:  \n\t",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            FormBox[\(\[Lambda](G(f, a, b))\),
              "TraditionalForm"], 
            "=", \(inf {S(f, P) : \ 
                  P\ \[Epsilon]\ \(\[WeierstrassP](a, b)\)}\)}],
          FontSize->18], TraditionalForm]]],
  ",  y   ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            FormBox[\(\[Lambda](G(f, a, b))\),
              "TraditionalForm"], "=", 
            RowBox[{"sup", 
              RowBox[{"{", 
                RowBox[{\(I(f, P)\), ":", " ", 
                  RowBox[{"P", " ", "\[Epsilon]", " ", 
                    RowBox[{
                      StyleBox["\[WeierstrassP]",
                        FontSize->18], "(", \(a, b\), ")"}]}]}], "}"}]}]}],
          FontSize->18], TraditionalForm]]],
  "\nDonde hemos representado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[WeierstrassP]",
            FontSize->18], "(", \(a, b\), ")"}], TraditionalForm]],
    FontSize->16],
  " el conjunto de ",
  StyleBox["todas",
    FontSlant->"Italic"],
  " las particiones de ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->16],
  ". Llegados aqu\[IAcute], podemos ya dar la definici\[OAcute]n principal de \
la teor\[IAcute]a de la integral de Riemann. "
}], "Text",
  FontSize->14],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Sea  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " una funci\[OAcute]n acotada y positiva en",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\ \)\([a, b]\)\),
          FontSize->16], TraditionalForm]]],
  ". Se dice que el conjunto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["G",
            FontSize->16], "(", 
          StyleBox[\(f, a, b\),
            FontSize->16], 
          StyleBox[")",
            FontSize->16]}], TraditionalForm]]],
  " tiene \[AAcute]rea cuando\n\t\t",
  StyleBox[" ",
    FontSize->18],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"inf", 
            RowBox[{"{", 
              RowBox[{\(S(f, P)\), ":", " ", 
                RowBox[{"P", " ", "\[Epsilon]", " ", 
                  RowBox[{
                    StyleBox["\[WeierstrassP]",
                      FontSize->18], "(", \(a, b\), ")"}]}]}], "}"}]}], "=", 
          RowBox[{"sup", 
            RowBox[{"{", 
              RowBox[{\(I(f, P)\), ":", " ", 
                RowBox[{"P", " ", "\[Epsilon]", " ", 
                  RowBox[{
                    StyleBox["\[WeierstrassP]",
                      FontSize->18], "(", \(a, b\), ")"}]}]}], "}"}]}]}], 
        TraditionalForm]],
    FontSize->18],
  "\nDicho valor com\[UAcute]n es, por definici\[OAcute]n, el valor del \
\[AAcute]rea y lo representaremos por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Lambda](G(f, a, b))\),
          FontSize->16], TraditionalForm]]],
  ". Cuando esto ocurre, se dice tambi\[EAcute]n que la ",
  StyleBox["funci\[OAcute]n f es integrable Riemann en",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\([a, b]\),
            FontSize->16]}], TraditionalForm]],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y, por definici\[OAcute]n, la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      FormBox[
        StyleBox[\([a, b]\),
          FontSize->16], TraditionalForm]]],
  " es igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Lambda](G(f, a, b))\),
          FontSize->16], TraditionalForm]]],
  ":\n\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(
              x)\) \[DifferentialD]x = \[Lambda](G(f, a, b))\)],
    FontSize->18],
  "\nEn el caso general en que la funci\[OAcute]n  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " toma valores positivos y negativos, se dice que ",
  StyleBox[" f es integrable Riemann en",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\([a, b]\),
            FontSize->16]}], TraditionalForm]],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " cuando lo son las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`f\^\(\(\ \)\(+\)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^-\)\)]],
  ", en cuyo caso se define  la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ",
  Cell[BoxData[
      FormBox[
        StyleBox[\([a, b]\),
          FontSize->16], TraditionalForm]]],
  " como el n\[UAcute]mero:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\),
            FontSize->18], 
          StyleBox["=",
            FontSize->18], 
          RowBox[{
            RowBox[{
              StyleBox["\[Lambda]",
                FontSize->18], 
              StyleBox["(",
                FontSize->18], 
              RowBox[{
                StyleBox["G",
                  FontSize->18], 
                StyleBox["(",
                  FontSize->18], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox["f",
                      FontSize->18], \(\(\ \ \ \)\(+\)\)], 
                  StyleBox[",",
                    FontSize->18], 
                  StyleBox["a",
                    FontSize->18], 
                  StyleBox[",",
                    FontSize->18], 
                  StyleBox["b",
                    FontSize->18]}], 
                StyleBox[")",
                  FontSize->18]}], 
              StyleBox[")",
                FontSize->18]}], 
            StyleBox["-",
              FontSize->18], 
            RowBox[{
              StyleBox["\[Lambda]",
                FontSize->18], 
              StyleBox["(",
                FontSize->18], 
              RowBox[{
                StyleBox["G",
                  FontSize->18], 
                StyleBox["(",
                  FontSize->18], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox["f",
                      FontSize->18], \(\(\ \ \)\(-\)\)], ",", "a", ",", "b"}],
                 
                StyleBox[")",
                  FontSize->18]}], 
              StyleBox[")",
                FontSize->18]}]}]}], TraditionalForm]]]
}], "Text",
  FontSize->14],

Cell["Observaciones", "Subsection"],

Cell[TextData[{
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " La definici\[OAcute]n anterior debes entenderla como una primera \
aproximaci\[OAcute]n matem\[AAcute]tica al concepto intuitivo de \
\[AAcute]rea. Aunque pueda parecerte extra\[NTilde]o, el concepto de \
\[AAcute]rea (y de integral) que acabamos de definir es bastante restrictivo. \
\n",
  StyleBox["\[FilledSmallCircle]",
    FontWeight->"Bold"],
  " En el caso en que la funci\[OAcute]n  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " toma valores positivos y negativos, observa que la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\^-\)\)]],
  " se obtiene por simetr\[IAcute]a respecto al eje de abscisas de las partes \
de la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  en las que ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) < 0\)]],
  ". Como regiones sim\[EAcute]tricas respecto de una recta tienen la misma \
\[AAcute]rea, se sigue que:\n\t",
  StyleBox[" ",
    Background->None],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\(\[Lambda](
                G(f, a, 
                  b)) = \ \(\[Lambda](G(\(f\^+\), a, b)) + \[Lambda](
                    G(\(f\^-\), a, b))\  = \(\[Lambda](
                    G(\(f\^+\) + \(f\^-\), a, x))\  = \ \(\[Lambda](
                      G(\(\(|\)\(f\)\(\ \)\(|\)\), a, 
                        x)) = \[Integral]\_a\%b\(\(|\)\(f(
                          x)\)\(|\)\(\(\[DifferentialD]x\)\(\ \)\(.\)\)\)\)\)\
\)\),
            Background->None]}], TraditionalForm]],
    Background->None],
  "\nSeamos pr\[AAcute]cticos. \[DownQuestion]C\[OAcute]mo podemos, a partir \
de la definici\[OAcute]n dada anteriormente, calcular",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\)],
    FontSize->16],
  "? Una primera idea en este sentido consiste en observar que cuanto mayor \
sea el n\[UAcute]mero de intervalos de la partici\[OAcute]n y m\[AAcute]s \
peque\[NTilde]a la anchura de cada uno de ellos cabe esperar que la \
aproximaci\[OAcute]n obtenida sea mejor. Para precisar esta idea, definimos \
el",
  StyleBox[" paso de una partici\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", y lo representamos por",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`\[Delta](P)\)],
    FontSize->16],
  ", como la mayor de las longitudes de los subintervalos de dicha partici\
\[OAcute]n. \nPuedes comprobar que, efectivamente, al ir disminuyendo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Delta](P)\),
          FontSize->16], TraditionalForm]]],
  " la aproximaci\[OAcute]n obtenida va mejorando. Ejecuta los comandos \
siguientes para ver las respectivas animaciones."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(Do[areasup[1.5 + Sin[x], {x, 1, 7, k}], {k, 8, 32, 3}];\)\)], "Input",\

  AnimationDisplayTime->0.2197],

Cell[BoxData[
    \(\(Do[areainf[1.5 + Sin[x], {x, 1, 7, k}], {k, 8, 32, 3}];\)\)], "Input"],

Cell[BoxData[
    \(\(Do[
        areasup[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8, k}], {k, 8, 32, 
          3}];\)\)], "Input",
  AnimationDisplayTime->0.13],

Cell[BoxData[
    \(\(Do[
        areainf[Exp[\(-x\)/17]\ Sin[x], {x, 1, 8, k}], {k, 8, 32, 
          3}];\)\)], "Input"],

Cell["\<\
\[DownQuestion]Convencido?  No debe extra\[NTilde]arte por ello el siguiente \
resultado.\
\>", "Text",
  FontSize->14],

Cell["Teorema (Convergencia de las sumas integrales)", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " una funci\[OAcute]n integrable, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\({P\_n}\),
          FontSize->16], TraditionalForm]]],
  " una sucesi\[OAcute]n de particiones de [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tal que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Delta](P\_n) \[Rule] 0\),
          FontSize->16], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Sigma](f, P\_n)\),
          FontSize->16], TraditionalForm]]],
  " una suma de Riemann de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " para la partici\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`P\_n\)],
    FontSize->16],
  ". Se verifica entonces que:\n\t",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(n \[Rule] \[Infinity]\)\ 
          S(f, P\_n) = \ \(lim\_\(n \[Rule] \[Infinity]\)\ 
            s(f, P\_n)\  = \ \(lim\_\(n \[Rule] \[Infinity]\)\[Sigma](f, 
                P\_n) = \[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\)\)\)],
    FontSize->18]
}], "Text",
  FontSize->14],

Cell[TextData[{
  "Este resultado permite en algunos casos particulares y con bastante \
esfuerzo e ingenio calcular ciertas integrales. Como m\[AAcute]s adelante \
aprenderemos a calcular integrales con facilidad, es m\[AAcute]s interesante \
usar dicho resultado ",
  StyleBox["sensu contrario",
    FontSlant->"Italic"],
  " para calcular los l\[IAcute]mites de ciertas sucesiones. "
}], "Text",
  FontSize->16],

Cell["\<\
Pues bien, ha llegado el momento de preguntarse por condiciones que \
garanticen que una funci\[OAcute]n es integrable Riemann. Nos vamos a \
contentar con una respuesta parcial a esta pregunta, que es suficiente para \
nuestros prop\[OAcute]sitos.\
\>", "Text",
  FontSize->16],

Cell["Teorema (Condiciones suficientes de integrabilidad Riemann)", \
"Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  ". Cada una de las siguientes condiciones garantizan que ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es integrable Riemann en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]:\n",
  StyleBox["i)",
    FontWeight->"Bold"],
  "   ",
  StyleBox["f",
    FontSlant->"Italic"],
  " est\[AAcute] acotada en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y tiene un n\[UAcute]mero finito de discontinuidades en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. En particular, toda funci\[OAcute]n continua en un intervalo ",
  StyleBox["cerrado y acotado",
    FontSlant->"Italic"],
  " es integrable en dicho intervalo.\n",
  StyleBox["ii)",
    FontWeight->"Bold"],
  "  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es mon\[OAcute]tona en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]."
}], "Text",
  FontSize->14],

Cell[TextData[{
  "La demostraci\[OAcute]n de este resultado, que no vamos a dar, consiste, \
en cada caso, en probar que dado un n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[CurlyEpsilon] > 0\),
          FontSize->16], TraditionalForm]]],
  ", hay una partici\[OAcute]n ",
  StyleBox["P",
    FontSlant->"Italic"],
  " del intervalo [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tal que  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(S(P, f)\  - \ s(P, f) < \[CurlyEpsilon]\),
          FontSize->16], TraditionalForm]]],
  "."
}], "Text",
  FontSize->14],

Cell[TextData[{
  "Teniendo en cuenta que ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            RowBox[{"\[Sigma]", "(", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{"\[Alpha]", 
                      StyleBox["f",
                        FontSize->16,
                        FontSlant->"Italic"]}]], 
                  StyleBox["+",
                    FontSize->16,
                    FontSlant->"Plain"], "\[Beta]g"}], ",", 
                StyleBox["P",
                  FontSize->16]}], ")"}], 
            "=", \(\[Alpha]\[Sigma](f, P) + \[Beta]\[Sigma](g, P)\)}],
          FontSize->16], TraditionalForm]]],
  ", cualesquiera sean las funciones ",
  StyleBox["f",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[", ",
    FontSize->16],
  StyleBox["g",
    FontSize->16,
    FontSlant->"Italic"],
  " y los n\[UAcute]meros",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\ \)\(\[Alpha], \ \[Beta]\)\),
          FontSize->16], TraditionalForm]]],
  ", se deduce, haciendo uso del resultado sobre convergencia de sumas \
integrales, que la integral es lineal. Esta propiedad, junto con otras \
propiedades b\[AAcute]sicas de las integrales se recogen en el siguiente \
resultado.  "
}], "Text",
  FontSize->14],

Cell["Teorema (Propiedades b\[AAcute]sicas de la integral)", "Subsection"],

Cell[TextData[{
  StyleBox["i)",
    FontWeight->"Bold"],
  " ",
  StyleBox["Linealidad",
    FontWeight->"Bold"],
  ". Si ",
  StyleBox["f,g",
    FontSlant->"Italic"],
  " son integrables en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y ",
  StyleBox["\[Alpha], \[Beta]",
    FontSize->16],
  " son n\[UAcute]meros reales, se verifica que la funci\[OAcute]n ",
  StyleBox["\[Alpha]",
    FontSize->16],
  StyleBox["f ",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox["+ \[Beta]",
    FontSize->16],
  StyleBox["g",
    FontSize->16,
    FontSlant->"Italic"],
  " tambi\[EAcute]n es integrable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y:\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\((\[Alpha]\ \(f(
                    x)\) + \[Beta]\ \(g(
                    x)\))\) \[DifferentialD]x = \[Alpha] \
\(\[Integral]\_a\%b\( f(
                  x)\) \[DifferentialD]x\)\  + \ \[Beta]\ \(\[Integral]\_a\%b\
\( g(x)\) \[DifferentialD]x\)\)],
    FontSize->16],
  StyleBox[".",
    FontSize->16],
  "\n",
  StyleBox["ii)",
    FontWeight->"Bold"],
  " ",
  StyleBox["Conservaci\[OAcute]n del orden",
    FontWeight->"Bold"],
  ". Si ",
  StyleBox["f,g",
    FontSlant->"Italic"],
  " son integrables en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(x) \[LessEqual] \ g(x)\),
          FontSize->16], TraditionalForm]]],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "], entonces se verifica que: \n\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(
              x)\) \[DifferentialD]x\  \[LessEqual] \ \[Integral]\_a\%b\( g(
              x)\) \[DifferentialD]x\)],
    FontSize->16],
  "\nEn particular, si  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es integrable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y ",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`m \[LessEqual] f(x) \[LessEqual] M\)],
    FontSize->16],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "], entonces se verifica la siguiente ",
  StyleBox["acotaci\[OAcute]n fundamental",
    FontWeight->"Bold"],
  ": \n\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`m(
          b - a)\  \[LessEqual] \ \[Integral]\_a\%b\( f(
              x)\) \[DifferentialD]x\  \[LessEqual] \ M(b - a)\)],
    FontSize->16],
  "\n",
  StyleBox["iii)",
    FontWeight->"Bold"],
  " Si  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es integrable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tambi\[EAcute]n | ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "| (funci\[OAcute]n valor absoluto de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ") es integrable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y se verifica la desigualdad:\n\t\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \
\)\(\(\[VerticalSeparator]\)\(\[Integral]\_a\%b\( f(
              x)\) \[DifferentialD]x\)\(\ \)\(\[VerticalSeparator]\)\(\(\(\
\[LessEqual]\)\(\ \)\(\[Integral]\_a\%b\)\)\  | 
          f(x) | \[DifferentialD]x\)\)\)\)],
    FontSize->16],
  "\n",
  StyleBox["iv)",
    FontWeight->"Bold"],
  " El producto de funciones integrables Riemann tambi\[EAcute]n es una funci\
\[OAcute]n integrable Riemann. \n",
  StyleBox["v)",
    FontWeight->"Bold"],
  " ",
  StyleBox["Aditividad respecto del intervalo",
    FontWeight->"Bold"],
  ".  Sea ",
  StyleBox["a < c ",
    FontSlant->"Italic"],
  "< ",
  StyleBox["b. ",
    FontSlant->"Italic"],
  "Una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es integrable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] si, y s\[OAcute]lo si, es integrable en [",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "] y en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "], en cuyo caso se verifica la igualdad:\n\t\t\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            FormBox[\(\[Integral]\_a\%b\( f(x)\) \[DifferentialD]x\),
              "TraditionalForm"], "=", 
            RowBox[{
              FormBox[\(\[Integral]\_a\%c\( f(x)\) \[DifferentialD]x\),
                "TraditionalForm"], "+", 
              FormBox[\(\[Integral]\_c\%b\( f(x)\) \[DifferentialD]x\),
                "TraditionalForm"]}]}],
          FontSize->16], TraditionalForm]]]
}], "Text",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell["El Teorema Fundamental del C\[AAcute]lculo", "Section"],

Cell[TextData[{
  "Dada una funci\[OAcute]n integrable ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " podemos definir una nueva funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox[":",
              FontSize->16], 
            StyleBox[\([a, b]\),
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [a, b]\)],
    FontSize->16],
  ". Nuestro pr\[OAcute]ximo objetivo va a ser estudiar dicha \
funci\[OAcute]n. Recuerda que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(F(x)\),
            FontSize->16], 
          StyleBox["=",
            FontSize->16], 
          RowBox[{
            RowBox[{
              StyleBox["\[Lambda]",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["G",
                  FontSize->16], 
                StyleBox["(",
                  FontSize->16], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox["f",
                      FontSize->16], \(\(\ \ \)\(+\)\)], 
                  StyleBox[",",
                    FontSize->16], 
                  StyleBox["a",
                    FontSize->16], 
                  StyleBox[",",
                    FontSize->16], 
                  StyleBox["x",
                    FontSize->16]}], 
                StyleBox[")",
                  FontSize->16]}], 
              StyleBox[")",
                FontSize->16]}], 
            StyleBox["-",
              FontSize->16], 
            RowBox[{
              StyleBox["\[Lambda]",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["G",
                  FontSize->16], 
                StyleBox["(",
                  FontSize->16], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox[\(\(f\)\(\ \)\),
                      FontSize->16], "-"], 
                  StyleBox[",",
                    FontSize->16], 
                  StyleBox["a",
                    FontSize->16], 
                  StyleBox[",",
                    FontSize->16], 
                  StyleBox["x",
                    FontSize->16]}], 
                StyleBox[")",
                  FontSize->16]}], 
              StyleBox[")",
                FontSize->16]}]}]}], TraditionalForm]]],
  ". Por supuesto, si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es una positiva entonces ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F(x) = \[Lambda](G(f, a, x))\),
          FontSize->16], TraditionalForm]]],
  " es el \[AAcute]rea de la regi\[OAcute]n del plano limitada por la gr\
\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " , el eje de abscisas y las rectas ",
  StyleBox["y=a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y=x",
    FontSlant->"Italic"],
  ". No debes olvidar en lo que sigue que ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  " se ha definido en t\[EAcute]rminos de \[AAcute]reas. \nEl comando \
\"areafunc[f[x], {x, a, b}, n, {ymin, ymax},opts]\" (admite opciones como \
\"Show\") da como salida n gr\[AAcute]ficas y en cada una de ellas representa \
la gr\[AAcute]fica de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(f, a, a + \(k(b - a)\)/n)\)]],
  " en azul, y la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \[Lambda](G(\(f\^+\), a, x)) - \[Lambda](
            G(\(f\^-\), a, x))\)]],
  ", en rojo, en el intervalo [",
  StyleBox["a,a+k(b-a)/n",
    FontSlant->"Italic"],
  "], para 1",
  StyleBox["\[LessEqual] k",
    FontSlant->"Italic"],
  " \[LessEqual] n. Adem\[AAcute]s, en cada caso da el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`F(a + \(k(b - a)\)/n)\)]],
  ". Para usar el comando tienes que fijar los valores \"ymin\" e \"ymax\" \
que determinan el intervalo del eje de ordenadas en que se representar\
\[AAcute]n las funciones. Experimenta con distintas funciones y \
f\[IAcute]jate si la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \[Lambda](G(\(f\^+\), a, x)) - \[Lambda](
            G(\(f\^-\), a, x))\)]],
  " te resulta conocida en algunos casos."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(areafunc[Cos[x], {x, 0, 2  \[Pi]}, 10, {\(-1.1\), 1.1}];\)\)], "Input"],

Cell[BoxData[
    \(\(areafunc[1/x, {x, 1, 6}, 10, {\(- .2\), 2}];\)\)], "Input"],

Cell[BoxData[
    \(\(areafunc[\ Sin[x]/x, {x, 0.01, 12}, 
        10, {\(- .8\), 2.1}];\)\)], "Input"],

Cell[BoxData[
    \(\(areafunc[Exp[\(-x\^2\)], {x, \(-2\), 2}, 10, {\(- .2\), 2}, 
        Frame \[Rule] True, 
        Background \[Rule] RGBColor[1,  .8,  .8]];\)\)], "Input",
  AnimationDisplayTime->0.169],

Cell[TextData[{
  "A veces puede ser conveniente considerar funciones de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \[Integral]\_\(\(\ \)\(c\)\)\%x\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  " en donde ",
  StyleBox["a < c < b ",
    FontSlant->"Italic"],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [a, b]\)]],
  " por lo que es necesario precisar lo que se entiende por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Integral]\_\(\(\ \)\(c\)\)\%x\),
            FontSize->16], \(\(f(t)\) \[DifferentialD]t\)}], 
        TraditionalForm]],
    FontSize->16],
  " cuando ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\  < \ c\),
          FontSize->16], TraditionalForm]]],
  ". El convenio que se hace es que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[
            RowBox[{
              FormBox[
                RowBox[{
                  StyleBox[\(\[Integral]\_\(\(\ \)\(u\)\)\%v\),
                    FontSize->16], \(\(f(t)\) \[DifferentialD]t\)}],
                "TraditionalForm"], "=", 
              RowBox[{"-", " ", 
                FormBox[
                  RowBox[{
                    StyleBox[\(\[Integral]\_\(\(\ \)\(v\)\)\%u\),
                      FontSize->16], \(\(f(t)\) \[DifferentialD]t\)}],
                  "TraditionalForm"]}]}],
            FontSize->16]}], TraditionalForm]]],
  " cualquiera sean los n\[UAcute]meros ",
  StyleBox["u",
    FontSlant->"Italic"],
  " y ",
  StyleBox["v",
    FontSlant->"Italic"],
  ". La justificaci\[OAcute]n de este convenio es que, con \[EAcute]l,  la \
igualdad\n\t\t\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_x\%y\( f(
                    t)\) \[DifferentialD]t + \[Integral]\_y\%z\( f(
                    t)\) \[DifferentialD]t + \[Integral]\_z\%x\( f(
                    t)\) \[DifferentialD]t = 0\),
          FontSize->16], TraditionalForm]]],
  "\nse cumple cualesquiera sean los puntos ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", ",
  StyleBox["z",
    FontSlant->"Italic"],
  " del intervalo [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Compru\[EAcute]balo. \nNuestro pr\[OAcute]ximo objetivo va a consistir \
en",
  StyleBox[" invertir el proceso",
    FontSlant->"Italic"],
  " que nos ha llevado de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F(x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
          FontSize->16], TraditionalForm]]],
  ". Nuestro problema es: \[DownQuestion]C\[OAcute]mo podemos recuperar la \
funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " a partir del conocimiento de la ",
  StyleBox["\"funci\[OAcute]n \[AAcute]rea de f\"",
    FontSlant->"Italic"],
  ", es decir, de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  "? Piensa un poco en las operaciones que hay que realizar sobre ",
  StyleBox["f",
    FontSlant->"Italic"],
  " para obtener su ",
  StyleBox["funci\[OAcute]n \[AAcute]rea",
    FontSlant->"Italic"],
  ". Dichas operaciones son: ",
  StyleBox["evaluar",
    FontSlant->"Italic"],
  " ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en algunos puntos del intervalo, ",
  StyleBox["multiplicar",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " dichos valores por las longitudes de subintervalos apropiados, ",
  StyleBox["sumar",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " todos estos n\[UAcute]meros y pasar al ",
  StyleBox["l\[IAcute]mite",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Todo ello queda reflejado en la igualdad que expresa la convergencia de \
las sumas de Riemann a la integral:\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`lim\ \(\[Sum]\+\(k = 1\)\%n\( f(
                t\_k)\) \((x\_k - x\_\(k - 1\))\)\) = \[Integral]\_a\%b\( f(
              t)\) \[DifferentialD]t\)],
    FontSize->16],
  "\nParece razonable que para invertir el proceso anterior, ",
  StyleBox["evaluemos",
    FontSlant->"Italic"],
  " ",
  StyleBox["F",
    FontSlant->"Italic"],
  " en puntos ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " del intervalo, hagamos la ",
  StyleBox["diferencia ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["F(x)\[NonBreakingSpace]-\[NonBreakingSpace]F(y), ",
    FontSlant->"Italic"],
  StyleBox["dividamos",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por la longitud del intervalo, ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          FractionBox[
            StyleBox[\(F(x) - F(y)\),
              FontSize->16], 
            StyleBox[\(x - y\),
              FontSize->16]],
          FontSize->16], TraditionalForm]]],
  ", y tomemos ",
  StyleBox["l\[IAcute]mites",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Como puedes ver, este proceso nos conduce de forma natural a estudiar la \
derivada de la ",
  StyleBox["funci\[OAcute]n \[AAcute]rea",
    FontSlant->"Italic"],
  ",",
  StyleBox[" F. ",
    FontSlant->"Italic"],
  "El resultado que sigue, uno de los m\[AAcute]s \[UAcute]tiles del C\
\[AAcute]lculo, establece una relaci\[OAcute]n entre dos conceptos \
aparentemente lejanos entre s\[IAcute]: el concepto de \[AAcute]rea y el de \
tangente a una curva. "
}], "Text",
  FontSize->14],

Cell["Teorema Fundamental del C\[AAcute]lculo", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " una funci\[OAcute]n integrable y definamos ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\),
          FontSize->16], TraditionalForm]]],
  " por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F(x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
          FontSize->16], TraditionalForm]]],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Entonces:\n",
  StyleBox["i)",
    FontWeight->"Bold"],
  "  ",
  StyleBox["F",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSize->16],
  "es continua en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "].\n",
  StyleBox["ii)",
    FontWeight->"Bold"],
  " En todo punto ",
  StyleBox["c",
    FontSlant->"Italic"],
  " de [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] en el que ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sea continua se verifica que ",
  StyleBox["F",
    FontSize->16,
    FontSlant->"Italic"],
  " es derivable en dicho punto siendo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F' \((c)\) = f(c)\),
          FontSize->16], TraditionalForm]]],
  ". En particular, si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es continua en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "], entonces ",
  StyleBox["F",
    FontSize->16,
    FontSlant->"Italic"],
  " es derivable en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] y ",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`F' \((x)\) = f(x)\)],
    FontSize->16],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "].\n",
  StyleBox["Demostraci\[OAcute]n",
    FontWeight->"Bold"],
  ".\n",
  StyleBox["i)",
    FontWeight->"Bold"],
  " Como ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es integrable debe estar acotada. Sea ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(M\)\(>\)\(0\)\(\ \)\),
          FontSize->16], TraditionalForm]]],
  "tal que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(f(x)\)\(|\)\(\(\[LessEqual]\)\(\ \)\(M\)\)\),
          FontSize->16], TraditionalForm]]],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Entonces, si  ",
  StyleBox["x < y",
    FontSlant->"Italic"],
  " son puntos de [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tenemos que:\n\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\(|\)\(F(y) - 
                F(x)\)\(|\)\) = \(\(\[VerticalSeparator]\)\(\[Integral]\_x\%y\
\( f(t)\) \[DifferentialD]t\)\(\[VerticalSeparator]\)\(\(\(\[LessEqual]\)\(\
\[Integral]\_x\%y\)\) | 
                f(t) | \[DifferentialD]t\  \[LessEqual] \ M(y - x)\)\)\),
          FontSize->16], TraditionalForm]]],
  "\nPor la misma raz\[OAcute]n, si suponemos que  ",
  StyleBox["y < x",
    FontSlant->"Italic"],
  ", tendremos que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(F(x) - 
          F(y)\)\(|\)\(\(\[LessEqual]\)\(\ \)\(M(x - y)\)\)\)\)]],
  ". Estas dos desigualdades nos dicen que  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(F(x) - 
          F(y)\)\(|\)\(\(\[LessEqual]\)\(\ \)\(M\)\)\(|\)\(x - 
          y\)\(|\)\)\)]],
  " para todo par de puntos ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " de [",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  "]. De esta desigualdad se sigue inmediatamente la continuidad de ",
  StyleBox["F",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  "]. \n",
  StyleBox["ii)",
    FontWeight->"Bold"],
  " Pongamos  \n\t",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FractionBox[
              StyleBox[\(F(x) - F(c)\),
                FontSize->16], 
              StyleBox[\(x - \ c\),
                FontSize->14]], "-", 
            StyleBox[\(f(c)\),
              FontSize->16]}], "=", " ", 
          RowBox[{
            FractionBox[
              StyleBox[\(F(x) - F(c) - \((x - c)\) \(f(c)\)\),
                FontSize->16], 
              StyleBox[\(x - \ c\),
                FontSize->14]], "=", 
            RowBox[{
              FractionBox[
                RowBox[{
                  RowBox[{
                    StyleBox[\(\[Integral]\_c\%x\),
                      FontSize->18], 
                    StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                      FontSize->16]}], "-", 
                  RowBox[{
                    StyleBox[\(f(c)\),
                      FontSize->14], 
                    RowBox[{
                      StyleBox[\(\[Integral]\_c\%x\),
                        FontSize->18], 
                      StyleBox[\(\[DifferentialD]t\),
                        FontSize->16]}]}]}], 
                StyleBox[\(x - \ c\),
                  FontSize->14]], "=", 
              FractionBox[
                RowBox[{
                  StyleBox[\(\[Integral]\_c\%x\),
                    FontSize->18], 
                  StyleBox[\(\((f(t) - f(c))\) \[DifferentialD]t\),
                    FontSize->16]}], 
                StyleBox[\(x - \ c\),
                  FontSize->14]]}]}]}], TraditionalForm]],
    FontSize->18],
  "\nDado, \[CurlyEpsilon]>0, la continuidad de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ",
  StyleBox["c",
    FontSlant->"Italic"],
  " nos dice que hay un \[Delta]>0 tal que para todo ",
  StyleBox["t \[Epsilon] ",
    FontSlant->"Italic"],
  "[",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tal que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(\ \)\(t\  - \ 
          c\)\(|\)\(\(<\)\(\[Delta]\)\(\ \)\)\)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "se tiene que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(f(t) - f(c)\)\(|\)\(\(<\)\(\[CurlyEpsilon]\)\)\),
          FontSize->16], TraditionalForm]]],
  ". Tomemos ahora un punto cualquiera ",
  StyleBox["x \[Epsilon] ",
    FontSlant->"Italic"],
  "[",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tal que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(x - c\)\(|\)\(\(<\)\(\[Delta]\)\)\)\)]],
  ". Entonces es claro que para todo ",
  StyleBox["t",
    FontSlant->"Italic"],
  " comprendido entre ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["c ",
    FontSlant->"Italic"],
  "se tendr\[AAcute] que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(t - c\)\(|\)\(\(<\)\(\[Delta]\)\)\)\)]],
  " y, por tanto, ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(|\)\(f(t) - f(c)\)\(|\)\(\(<\)\(\[CurlyEpsilon]\)\)\),
          FontSize->16], TraditionalForm]]],
  " por lo que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\(\(\[VerticalSeparator]\)\(\[Integral]\_c\%x\((f(t) - 
                      f(c))\) \[DifferentialD]t\)\(\[VerticalSeparator]\)\(\(\
\(\[LessEqual]\)\(\[CurlyEpsilon]\)\) | x - c | \)\),
            FontSize->16]}], TraditionalForm]]],
  ". Deducimos que para todo ",
  StyleBox["x \[Epsilon] ",
    FontSlant->"Italic"],
  "[",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] tal que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(\ \)\(x\  - \ 
          c\)\(|\)\(\(<\)\(\[Delta]\)\)\)\)]],
  ", ",
  StyleBox["x \[NotEqual] c",
    FontSlant->"Italic"],
  ", se verifica que:\n\t\t\t ",
  Cell[BoxData[
      FormBox[
        RowBox[{"  ", 
          RowBox[{
            RowBox[{"\[VerticalSeparator]", 
              RowBox[{
                FractionBox[
                  StyleBox[\(\(\ \)\(F(x) - F(c)\)\),
                    FontSize->16], 
                  StyleBox[\(x - \ c\),
                    FontSize->14]], "-", 
                StyleBox[\(f(c)\),
                  FontSize->16]}], "\[VerticalSeparator]"}], "=", 
            RowBox[{
              RowBox[{"\[VerticalSeparator]", 
                FractionBox[
                  RowBox[{
                    StyleBox[\(\[Integral]\_c\%x\),
                      FontSize->18], 
                    StyleBox[\(\((f(t) - f(c))\) \[DifferentialD]t\),
                      FontSize->16]}], 
                  StyleBox[\(x - \ c\),
                    FontSize->16]], "\[VerticalSeparator]", 
                RowBox[{"\[LessSlantEqual]", 
                  FractionBox[
                    StyleBox[\(\[CurlyEpsilon] | x - \ c | \),
                      FontSize->16], 
                    StyleBox[\(\(|\)\(x - \ c\)\(|\)\),
                      FontSize->16]]}]}], "=", "\[CurlyEpsilon]"}]}]}], 
        TraditionalForm]]],
  "\nHemos probado as\[IAcute] que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox[\(lim\_\(x \[Rule] c\)\),
                FontSize->16], " ", 
              FractionBox[
                StyleBox[\(F(x) - F(c)\),
                  FontSize->16], 
                StyleBox[\(x - \ c\),
                  FontSize->16]]}], "=", " ", 
            StyleBox[\(f(c)\),
              FontSize->16]}]}], TraditionalForm]]],
  ", esto es,",
  StyleBox[" ",
    FontSize->16],
  StyleBox["F",
    FontSize->16,
    FontSlant->"Italic"],
  " es derivable en ",
  StyleBox["c",
    FontSlant->"Italic"],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`F' \((c)\) = f(c)\)],
    FontSize->16],
  "."
}], "Text",
  FontSize->14],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Dada un funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"h", 
            StyleBox[":",
              FontSize->16], 
            StyleBox[\([a, b]\),
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  ", cualquier funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"H", 
            StyleBox[":",
              FontSize->16], 
            StyleBox[\([a, b]\),
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  " que sea continua en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "], derivable en ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[ y verifique que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(H' \((x)\) = h(x)\),
          FontSize->16], TraditionalForm]]],
  " para todo ",
  StyleBox["x \[Element]",
    FontSlant->"Italic"],
  " ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[, se llama una ",
  StyleBox["primitiva",
    FontWeight->"Bold"],
  " de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en el intervalo [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "].\nEs importante advertir que no todas las funciones tienen primitivas. \
Una condici\[OAcute]n ",
  StyleBox["necesaria",
    FontSlant->"Italic"],
  " que debe cumplir una funci\[OAcute]n para tener primitivas es que dicha \
funci\[OAcute]n tenga la propiedad del valor ",
  StyleBox["intermedio",
    FontSlant->"Italic"],
  " pues, como recordar\[AAcute]s,  las funciones derivadas tienen esa \
propiedad. Tambi\[EAcute]n, como consecuencia del teorema del valor medio, es \
inmediato que dos primitivas de una funci\[OAcute]n en un mismo intervalo se \
diferencian en una constante. Por ello, si conocemos una primitiva de una \
funci\[OAcute]n en un intervalo las conocemos todas. Precisamente, una \
consecuencia muy importante del Teorema Fundamental del C\[AAcute]lculo es \
que ",
  StyleBox["toda funci\[OAcute]n continua en un intervalo tiene primitivas en \
dicho intervalo",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Adem\[AAcute]s, el teorema nos dice que la ",
  StyleBox["funci\[OAcute]n \[AAcute]rea",
    FontSlant->"Italic"],
  ", esto es, la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F(x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
          FontSize->16], TraditionalForm]]],
  " es ",
  StyleBox["la",
    FontSlant->"Italic"],
  " primitiva de la funci\[OAcute]n continua  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"f", 
            StyleBox[":",
              FontSize->16], 
            StyleBox[\([a, b]\),
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  ", que se anula en ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`F(a) = 0\)]],
  ". Es importante que aprecies que este es un teorema de ",
  StyleBox["existencia",
    FontSlant->"Italic"],
  "; es la definici\[OAcute]n que hemos dado de \[AAcute]rea - y por \
consiguiente de integral - lo que nos ha permitido construir la \
funci\[OAcute]n primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ". No lo olvides:  la integraci\[OAcute]n es una potente herramienta para \
construir nuevas funciones."
}], "Text",
  FontSize->14],

Cell[TextData[{
  "El Teorema Fundamental del C\[AAcute]lculo proporciona una t\[EAcute]cnica \
para calcular la integral de una funci\[OAcute]n continua en un intervalo [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Para ello lo que hacemos es obtener una primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Si ",
  StyleBox["h",
    FontSlant->"Italic"],
  " es una tal primitiva, entonces las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(x \[RightTeeArrow] \ h(x) - h(a)\)\)\)]],
  ", y ",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\ \)\(x\  \[RightTeeArrow] \ \[Integral]\_a\%x\( f(
                  t)\) \[DifferentialD]t\)\),
          FontSize->16], TraditionalForm]]],
  " son dos primitivas de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "] que coinciden en un punto, pues ambas se anulan en ",
  StyleBox["a",
    FontSlant->"Italic"],
  ". Deducimos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\  = \ \ h(
                x) - h(a)\),
          FontSize->16], TraditionalForm]]],
  ", por lo que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_a\%b\( f(t)\) \[DifferentialD]t\  = \ \ h(
                b) - h(a)\),
          FontSize->16], TraditionalForm]]],
  ". Podemos generalizar este resultado como sigue."
}], "Text",
  FontSize->14],

Cell["Regla de Barrow", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"f", 
            StyleBox[":",
              FontSize->16], 
            StyleBox[\([a, b]\),
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  " integrable y supongamos que ",
  StyleBox["h",
    FontSlant->"Italic"],
  " es una primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Entonces ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Integral]\_a\%b\( f(t)\) \[DifferentialD]t\  = \ \ h(
                b) - h(a)\),
          FontSize->16], TraditionalForm]]],
  ".\nF\[IAcute]jate que en el resultado anterior no se supone que ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sea continua sino tan s\[OAcute]lo que es integrable y que, ",
  StyleBox["adem\[AAcute]s",
    FontSlant->"Italic"],
  ", tiene una primitiva. La idea de la demostraci\[OAcute]n es como sigue. \
Tomemos una partici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            
            StyleBox[\(P = {x\_0 = a, \ x\_1, \ x\_2,  ... , \ x\_\(n - 1\), 
                  x\_n = b}\),
              FontSize->16],
            "TraditionalForm"]}], TraditionalForm]]],
  "del intervalo [",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "]. Entonces podemos escribir:\n",
  Cell[BoxData[
      FormBox[
        RowBox[{\(h(b) - h(a)\), "=", 
          
          RowBox[{\(\[Sum]\+\(k = 1\)\%n\((h(x\_k) - h(x\_\(k - 1\)))\)\), 
            "=", 
            
            RowBox[{\(\[Sum]\+\(k = 1\)\%n 
                    h' \((t\_k)\) \((x\_k - x\_\(k - 1\))\)\), "=", 
              RowBox[{\(\[Sum]\+\(k = 1\)\%n\), 
                RowBox[{
                  RowBox[{
                    StyleBox["f",
                      FontSize->16], "(", \(t\_k\), ")"}], 
                  
                  RowBox[{\((x\_k - x\_\(k - 1\))\), " ", "\[LongRightArrow]",
                     
                    RowBox[{
                      StyleBox[\(\[Integral]\_a\%b\),
                        
                        FontSize->18], \(\(f(
                          t)\) \[DifferentialD]t\)}]}]}]}]}]}]}], 
        TraditionalForm]],
    FontSize->16],
  "\ndonde hemos usado el teorema del valor medio."
}], "Text",
  FontSize->14],

Cell["Algunas observaciones sobre el c\[AAcute]lculo de integrales", \
"Subsection"],

Cell[TextData[{
  "De lo antes dicho, se sigue que para calcular ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  " donde ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es una funci\[OAcute]n continua, hay que calcular una primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", evaluarla en ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y en ",
  StyleBox["b",
    FontSlant->"Italic"],
  " y hacer la diferencia. Pero, \[DownQuestion]para qu\[EAcute] calcular una \
primitiva? \[DownQuestion]no sabemos ya que una primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  "? Y, naturalmente, ",
  StyleBox["cualquier otra",
    FontSlant->"Italic"],
  " ser\[AAcute] de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\  + 
        C\)],
    FontSize->16],
  " donde ",
  StyleBox["C",
    FontSlant->"Italic"],
  " es una constante. \[DownQuestion]Qu\[EAcute] inter\[EAcute]s tiene \
entonces el c\[AAcute]lculo de primitivas de funciones continuas? Respuesta: \
desde un punto de vista te\[OAcute]rico ",
  StyleBox["ninguno",
    FontSlant->"Italic"],
  ". Ahora, si lo que queremos es calcular el  ",
  StyleBox["n\[UAcute]mero",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  ", entones la ",
  StyleBox["\"primitiva",
    FontSlant->"Italic"],
  " ",
  StyleBox["trivial\"",
    FontSlant->"Italic"],
  " de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", esto es, la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(F(x) = \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
            FontSize->16]}], TraditionalForm]]],
  ", no nos sirve para nada porque si la evaluamos en ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y en ",
  StyleBox["b",
    FontSlant->"Italic"],
  " y hacemos la diferencia, obtenemos una identidad perfectamente \
in\[UAcute]til para nuestros prop\[OAcute]sitos. Lo que necesitamos es \
conocer una primitiva ",
  StyleBox["f",
    FontSlant->"Italic"],
  " que sea  ",
  StyleBox["realmente evaluable",
    FontSlant->"Italic"],
  ", es decir que al evaluarla en ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y en ",
  StyleBox["b",
    FontSlant->"Italic"],
  " proporcione valores num\[EAcute]ricos. En otros t\[EAcute]rminos, ",
  StyleBox["el problema del c\[AAcute]lculo de primitivas consiste en tratar \
de expresar la",
    FontSlant->"Italic"],
  " ",
  StyleBox["\"primitiva",
    FontSlant->"Italic"],
  " ",
  StyleBox["trivial\"",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(F(x) = \ \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
            FontSize->16]}], TraditionalForm]]],
  " ",
  StyleBox["por medio de funciones elementales",
    FontSlant->"Italic"],
  " que permitan una evaluaci\[OAcute]n efectiva de la integral. Para eso \
sirven las  t\[EAcute]cnicas de c\[AAcute]lculo de primitivas. Pero sucede \
con frecuencia que no hay forma de expresar la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(F(x) = \ \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\),
            FontSize->16]}], TraditionalForm]]],
  " por medio de funciones elementales. Esto ocurre, por ejemplo, cuando ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(sen(x)\)/x\)],
    FontSize->16],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = exp(x\^2)\)],
    FontSize->16],
  ", en tales casos la forma m\[AAcute]s sencilla de representar una \
primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es justamente mediante la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`F(
          x) = \ \[Integral]\_a\%x\( f(t)\) \[DifferentialD]t\)],
    FontSize->16],
  " y, para obtener valores concretos de dicha funci\[OAcute]n hay que \
recurrir a m\[EAcute]todos num\[EAcute]ricos de c\[AAcute]lculo de \
integrales."
}], "Text",
  FontSize->14],

Cell["A vueltas con las funciones logaritmo y exponencial ", "Subsection"],

Cell[TextData[{
  "Quiero convencerte de que muchas veces el c\[AAcute]lculo integral \
proporciona la interpretaci\[OAcute]n m\[AAcute]s ituitiva de una funci\
\[OAcute]n. Considera, por ejemplo, la funci\[OAcute]n logaritmo natural. \
Quiz\[AAcute]s sepas expresar ",
  Cell[BoxData[
      \(TraditionalForm\`log(2)\)]],
  " como l\[IAcute]mite de una sucesi\[OAcute]n o algo parecido; pero, \
\[DownQuestion]puedes representar de alguna forma intuitiva el n\[UAcute]mero \
",
  Cell[BoxData[
      \(TraditionalForm\`log(2)\)]],
  "? \[DownQuestion]Sabr\[IAcute]as representar gr\[AAcute]ficamente el n\
\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`log(2)\)]],
  "? Eval\[UAcute]a la siguente celda para ",
  StyleBox["ver",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`log(2)\)]],
  "."
}], "Text",
  FontSize->14],

Cell[BoxData[
    \(\(logdos;\)\)], "Input"],

Cell[TextData[{
  "Espero que est\[EAcute]s de acuerdo conmigo: la forma m\[AAcute]s f\
\[AAcute]cil e intuitiva de imaginar el n\[UAcute]mero",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(log(t)\),
            FontSize->16]}], TraditionalForm]]],
  " es como el \[AAcute]rea de la regi\[OAcute]n plana limitada por la curva \
",
  Cell[BoxData[
      \(TraditionalForm\`y = 1/x\)]],
  ", las rectas ",
  StyleBox["y=",
    FontSlant->"Italic"],
  "1, ",
  StyleBox["y=",
    FontSlant->"Italic"],
  "t, y el eje de abscisas. Dicha \[AAcute]rea se considera positiva si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t > 1\),
          FontSize->16], TraditionalForm]]],
  "y negativa si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(t < 1\),
          FontSize->16], TraditionalForm]]],
  ". Dicho de otra forma, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(log(t)\),
            FontSize->16], "=", 
          RowBox[{
            StyleBox[
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  FontSize->18], "1", \(\(\[ThinSpace]\)\(t\)\)],
              FontSize->16], 
            RowBox[{
              StyleBox[
                FractionBox["1", 
                  StyleBox["x",
                    FontSize->16]],
                FontSize->16], \(\[DifferentialD]x\)}]}]}], 
        TraditionalForm]]],
  ". Olvida ahora todo lo que sepas de la funci\[OAcute]n logaritmo natural. \
\[DownQuestion]Lo has olvidado ya? Pues, bien, ahora vamos a ",
  StyleBox["definir",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" la funci\[OAcute]n logaritmo natural",
    FontSlant->"Italic"],
  " como la funci\[OAcute]n  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["log",
              FontSize->16], ":", \(\[DoubleStruckCapitalR]\^+\)}], "\[Rule]",
           " ", "\[DoubleStruckCapitalR]"}], TraditionalForm]],
    FontSize->16],
  "dada por  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(log(x)\),
            FontSize->16], "=", 
          RowBox[{
            StyleBox[
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  FontSize->18], "1", \(\(\[ThinSpace]\)\(x\)\)],
              FontSize->16], 
            RowBox[{
              StyleBox[
                FractionBox["1", 
                  StyleBox["t",
                    FontSize->16]],
                FontSize->16], \(\[DifferentialD]t\)}]}]}], 
        TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ". El Teorema Fundamental del C\[AAcute]lculo nos dice que dicha funci\
\[OAcute]n es derivable y",
  Cell[BoxData[
      FormBox[
        RowBox[{"  ", 
          StyleBox[
            RowBox[{
              FormBox[\(log' \((x)\)\),
                "TraditionalForm"], "=", \(1/x\)}],
            FontSize->16]}], TraditionalForm]]],
  ". Como la derivada es positiva, deducimos que dicha funci\[OAcute]n es \
estrictamente creciente. Ahora, dado,  ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ", sea ",
  Cell[BoxData[
      \(TraditionalForm\`h(x) = log(a\[ThinSpace]x)\)]],
  ". Entonces ",
  Cell[BoxData[
      \(TraditionalForm\`h' \((x)\) = \(a/a\[ThinSpace]x = 1/x\)\)]],
  "; luego la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(h(x) - log(x)\),
          FontSize->16], TraditionalForm]]],
  "tiene derivada nula en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^+\)\)],
    FontSize->16],
  ", por lo que es constante y, como para",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(x = 1\)\)\)]],
  " es igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(log(a)\),
          FontSize->16], TraditionalForm]]],
  ", se sigue que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(h(x) - log(x) = log(a)\),
          FontSize->16], TraditionalForm]]],
  ". Hemos probado que",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`log(a\[ThinSpace]x) = log(a) + log(x)\)],
    FontSize->16],
  " para todo  ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  " y para todo  ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ". Observa que en poco m\[AAcute]s de tres l\[IAcute]neas hemos obtenido ya \
las propiedades principales del logaritmo. Sigamos nuestro estudio. Como ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(log(2\^n) = n\ \(log(2)\)\),
          FontSize->16], TraditionalForm]]],
  " para todo n\[UAcute]mero ",
  StyleBox["entero",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", deducimos que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`log(x)\)]],
  " no est\[AAcute] mayorada ni minorada y, como es estrictamente creciente, \
concluimos que ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(x \[Rule] 0\)log(x) = \(-\[Infinity]\)\)],
    FontSize->16],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(x \[Rule] \(+\[Infinity]\)\)log(
            x) = \(+\[Infinity]\)\)],
    FontSize->16],
  ". Por tanto, podemos afirmar que",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[\(log(x)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es una biyecci\[OAcute]n estrictamente creciente de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^+\)\)],
    FontSize->16],
  "sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\)],
    FontSize->16],
  ". Representemos provisionalmente por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["\[CurlyPhi]",
              FontSize->16], 
            StyleBox[":",
              FontSize->18], 
            StyleBox["\[DoubleStruckCapitalR]",
              FontSize->16]}], 
          StyleBox["\[Rule]",
            FontSize->16], 
          StyleBox[" ",
            FontSize->16], 
          StyleBox["\[DoubleStruckCapitalR]",
            FontSize->16]}], TraditionalForm]]],
  " la funci\[OAcute]n inversa del logaritmo. Dicha funci\[OAcute]n se llama \
funci\[OAcute]n ",
  StyleBox["exponencial natural",
    FontSlant->"Italic"],
  ". El teorema de derivaci\[OAcute]n de la inversa nos dice que ",
  Cell[BoxData[
      FormBox[
        StyleBox["\[CurlyPhi]",
          FontSize->16], TraditionalForm]]],
  " es derivable y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[CurlyPhi]' \((x)\)\),
            FontSize->16], 
          StyleBox["=",
            FontSize->18], 
          StyleBox[\(1/log' \((\[CurlyPhi](x))\) = \[CurlyPhi](x)\),
            FontSize->16]}], TraditionalForm]]],
  " para todo n\[UAcute]mero real ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". Ahora, dados, ",
  Cell[BoxData[
      \(TraditionalForm\`x, y\  \[Element] \ \[DoubleStruckCapitalR]\)]],
  ", sean ",
  Cell[BoxData[
      \(TraditionalForm\`a, b > 0\)]],
  " tales que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = \ log(a), \ y = log(b)\),
          FontSize->16], TraditionalForm]]],
  ". Entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[CurlyPhi](x + y)\),
            FontSize->16], 
          StyleBox["=",
            FontSize->16], 
          RowBox[{
            StyleBox[\(\[CurlyPhi](log(a) + log(b))\),
              FontSize->16], 
            StyleBox["=",
              FontSize->16], 
            RowBox[{
              StyleBox[\(\[CurlyPhi](log(a\[ThinSpace]b))\),
                FontSize->16], 
              StyleBox["=",
                FontSize->18], 
              
              StyleBox[\(a\[ThinSpace]b = \(\[CurlyPhi](x)\) \(\[CurlyPhi](
                      y)\)\),
                FontSize->16]}]}]}], TraditionalForm]],
    FontSize->16],
  ". De la igualdad ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[CurlyPhi](
              x + y) = \(\[CurlyPhi](x)\) \(\[CurlyPhi](y)\)\),
          FontSize->16], TraditionalForm]],
    FontSize->16],
  " se deduce f\[AAcute]cilmente que ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\(\[CurlyPhi](r)\), "=", 
            SuperscriptBox[\(\[CurlyPhi](1)\), 
              StyleBox["r",
                FontSize->16]]}],
          FontSize->16], TraditionalForm]]],
  "para todo n\[UAcute]mero racional ",
  StyleBox["r. ",
    FontSlant->"Italic"],
  "El n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[CurlyPhi](1)\),
          FontSize->16], TraditionalForm]]],
  " se representa con la letra ",
  StyleBox["e",
    FontSlant->"Italic"],
  ", es decir, es el n\[UAcute]mero definido por la igualdad  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(log(e)\),
            FontSize->16], "=", 
          RowBox[{
            RowBox[{
              StyleBox[
                SubsuperscriptBox[
                  StyleBox["\[Integral]",
                    FontSize->18], "1", \(\(\[ThinSpace]\)\(e\)\)],
                FontSize->16], 
              RowBox[{
                StyleBox[
                  FractionBox["1", 
                    StyleBox["t",
                      FontSize->16]],
                  FontSize->16], \(\[DifferentialD]t\)}]}], "=", "1"}]}], 
        TraditionalForm]]],
  ". Con ello ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[CurlyPhi](r) = e\^\(\(\ \)\(r\)\)\),
          FontSize->16], TraditionalForm]]],
  "para todo n\[UAcute]mero racional ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", por lo que se usa la notaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[CurlyPhi](x) = e\^x\)],
    FontSize->16],
  "para representar a la funci\[OAcute]n exponencial. \nF\[IAcute]jate con qu\
\[EAcute] facilidad y elegancia hemos obtenido las propiedades principales de \
las funciones logaritmo y exponencial naturales. La definici\[OAcute]n que \
hemos dado de la funci\[OAcute]n logaritmo tiene tambi\[EAcute]n la ventaja \
de que algunas desigualdades resultan gr\[AAcute]ficamente evidentes.Por \
ejemplo, la desigualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(1/2 + 1/3 +  ... \) + 1/n \[LessEqual] \ 
            log\ n \[LessEqual] \ 1 + 1/2 +  ... \) + 1/\((n - 1)\)\)]],
  ". Las gr\[AAcute]ficas siguientes son una ",
  StyleBox["demostraci\[OAcute]n sin palabras",
    FontSlant->"Italic"],
  " de la desigualdad anterior para ",
  Cell[BoxData[
      \(TraditionalForm\`n = 8\)]],
  "."
}], "Text",
  TextAlignment->Left,
  FontSize->14],

Cell[BoxData[
    \(\(Show[{areasup[1/x, {x, 1, 8, 7}], areainf[1/x, {x, 1, 8, 7}]}, 
        DisplayFunction \[Rule] Identity];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Integrales de funciones no acotadas o en intervalos no acotados\
\>", "Section"],

Cell[TextData[{
  "\[DownQuestion]Es posible asignar \[AAcute]rea a una regi\[OAcute]n no \
acotada del plano? A primera vista, puede parecer que cualquier \
regi\[OAcute]n no acotada del plano (coloquialmente hablando, una regi\
\[OAcute]n infinita o ilimitada) debe tener \[AAcute]rea infinita. Una \
primera reflexi\[OAcute]n te convencer\[AAcute] de que eso no tiene por qu\
\[EAcute] ser as\[IAcute]. Por ejemplo, recuerda que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(arctg(x)\), "=", 
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                StyleBox["x",
                  FontSize->16]],
              FontSize->18], 
            RowBox[{
              FractionBox[
                StyleBox["1",
                  FontSize->16], 
                StyleBox[\(1\  + \ t\^2\),
                  FontSize->16]], \(\[DifferentialD]t\)}]}]}], 
        TraditionalForm]],
    FontSize->16],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`lim\_\(x \[Rule] \(+\[Infinity]\)\)\ 
          arctg(x) = \[Pi]/2\)]],
  ". Parece por tanto razonable ",
  StyleBox["definir",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                RowBox[{
                  StyleBox["+",
                    FontSize->14], "\[Infinity]"}]],
              FontSize->18], 
            RowBox[{
              FractionBox[
                StyleBox["1",
                  FontSize->16], 
                StyleBox[\(1\  + \ t\^2\),
                  FontSize->16]], \(\[DifferentialD]t\)}]}], 
          "=", \(\[Pi]/2\)}], TraditionalForm]]],
  " e interpretar dicha integral como el \[AAcute]rea de la regi\[OAcute]n no \
acotada del plano comprendida entre la curva ",
  Cell[BoxData[
      FormBox[
        RowBox[{"y", "=", 
          FractionBox[
            StyleBox["1",
              FontSize->16], 
            StyleBox[
              RowBox[{"1", " ", "+", " ", 
                SuperscriptBox[
                  StyleBox["x",
                    FontSize->16], "2"]}],
              FontSize->16]]}], TraditionalForm]]],
  " y el semieje positivo ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(x \[GreaterEqual] 0\),
            FontSize->16]}], TraditionalForm]]],
  ". Otro ejemplo m\[AAcute]s evidente: considera la regi\[OAcute]n del plano \
",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\[CapitalOmega]\)\(\ \)\),
          FontSize->16], TraditionalForm]]],
  "formada por la uni\[OAcute]n de los rect\[AAcute]ngulos ",
  Cell[BoxData[
      \(TraditionalForm\`R\_n\)]],
  "que tienen como base el intervalo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\([n, n + 1]\),
          FontSize->16], TraditionalForm]]],
  " y altura ",
  Cell[BoxData[
      \(TraditionalForm\`1/2\^n\)]],
  ", donde ",
  StyleBox["n",
    FontSlant->"Italic"],
  " es un n\[UAcute]mero natural. Evidentemente, se trata de una \
regi\[OAcute]n no acotada. Parece l\[OAcute]gico definir su \[AAcute]rea como \
el \[IAcute]mite:\n\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{"  ", 
          
          StyleBox[\(\[Lambda](\[CapitalOmega]) = \(lim\_\(n \[Rule] \
\[Infinity]\)\((\(\[Lambda](R\_1) + \[Lambda](R\_2) +  ... \) + \[Lambda](
                        R\_n))\) = \ \ \(lim\_\(n \[Rule] \[Infinity]\)\((\(1/
                              2 + 1/4 +  ... \) + 1/2\^n)\) = 1\)\)\),
            FontSize->16]}], TraditionalForm]]],
  "\nSeguro que ahora se te ocurren otros ejemplos. Pues bien, nuestro \
objetivo va a consistir en asignar \[AAcute]rea a regiones del plano ",
  StyleBox["no",
    FontSlant->"Italic"],
  " ",
  StyleBox["acotadas",
    FontSlant->"Italic"],
  " de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["G",
            FontSize->16], 
          StyleBox["(",
            FontSize->16], 
          RowBox[{
            StyleBox["f",
              FontSize->16], 
            StyleBox[",",
              FontSize->16], 
            StyleBox["a",
              FontSize->16,
              FontSlant->"Italic"], 
            StyleBox[",",
              FontSize->16,
              FontSlant->"Italic"], 
            StyleBox["b",
              FontSize->16,
              FontSlant->"Italic"]}], 
          StyleBox[")",
            FontSize->16,
            FontSlant->"Italic"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\) \[LessEqual] a < 
        b \[LessEqual] \(+\[Infinity]\)\)],
    FontSize->16],
  ", y  ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es una ",
  StyleBox["funci\[OAcute]n continua",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["en el intervalo de extremos",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". Se trata, naturalmente, de la regi\[OAcute]n del plano comprendida entre \
la curva ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(y = f(x)\),
          FontSize->16], TraditionalForm]]],
  " y el intervalo del eje de abscisas de extremos ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["b.",
    FontSlant->"Italic"],
  " Recuerda que toda funci\[OAcute]n continua en un intervalo cerrado y \
acotado est\[AAcute] acotada en dicho intervalo, por lo que la regi\[OAcute]n \
",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{
              StyleBox["G",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["a",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}],
            "TraditionalForm"]}], TraditionalForm]]],
  " ser\[AAcute] no acotada cuando ocurra una o las dos posibles situaciones \
siguientes:\ni)",
  StyleBox[" ",
    FontSize->16],
  Cell[BoxData[
      \(TraditionalForm\`a = \(-\[Infinity]\)\)],
    FontSize->16],
  ", o ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b = \(+\[Infinity]\)\),
          FontSize->16], TraditionalForm]]],
  "; es decir, el intervalo de extremos ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", no est\[AAcute] acotado: es una semirecta o toda la recta real; \nii) La \
funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " no est\[AAcute] acotada.\nLa consideraci\[OAcute]n por separado de cada \
uno de los casos que pueden darse ser\[IAcute]a repetitiva y aburrida; es \
posible, sin embargo, reducir esencialmente todas las posibilidades a una \
sola. Para ello, observa que si ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(a < c < b\),
          FontSize->16], TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["G",
              FontSize->16], 
            StyleBox["(",
              FontSize->16], 
            RowBox[{
              StyleBox["f",
                FontSize->16], 
              StyleBox[",",
                FontSize->16], 
              StyleBox["a",
                FontSize->16,
                FontSlant->"Italic"], 
              StyleBox[",",
                FontSize->16,
                FontSlant->"Italic"], 
              StyleBox["b",
                FontSize->16,
                FontSlant->"Italic"]}], 
            StyleBox[")",
              FontSize->16,
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{
              StyleBox["G",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["a",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["c",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}], "\[Union]", 
            RowBox[{
              StyleBox["G",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["c",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}]}]}], TraditionalForm]]],
  " por lo que es suficiente para nuestros prop\[OAcute]sitos considerar \
intervalos del tipo ]",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "] o [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ donde ",
  StyleBox["c",
    FontSlant->"Italic"],
  " es un n\[UAcute]mero real y ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\) \[LessEqual] a\)],
    FontSize->16],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(b\  \[LessEqual] \(+\[Infinity]\)\),
            FontSize->16]}], TraditionalForm]]],
  ". Como la teor\[IAcute]a resultante en ambos casos es totalmente sim\
\[EAcute]trica,",
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  "consideraremos en lo que sigue solamente intervalos de tipo [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ donde ",
  StyleBox["c",
    FontSlant->"Italic"],
  " es un n\[UAcute]mero real y ",
  StyleBox["b",
    FontSlant->"Italic"],
  " es un n\[UAcute]mero real mayor que ",
  StyleBox["c",
    FontSlant->"Italic"],
  " o bien  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(b = \(+\[Infinity]\)\),
          FontSize->16], TraditionalForm]]],
  ", dejando como ejercicio la traducci\[OAcute]n para intervalos del tipo \
]",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "] de las definiciones y resultados que siguen."
}], "Text",
  FontSize->14],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  " continua en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. Si existe y es finito el l\[IAcute]mite ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(lim\_\(x \[Rule] b\)\),
            FontSize->16], 
          StyleBox[" ",
            FontSize->18], 
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "c", 
                StyleBox["x",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}]}], TraditionalForm]]],
  " se dice que la ",
  StyleBox["integral de f es convergente",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. En tal caso, se define la ",
  StyleBox["integral de f ",
    FontSlant->"Italic"],
  "en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ como el n\[UAcute]mero:\t\t\t\t\t\t\t\n\t\t\t\t\t",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{" ", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubsuperscriptBox["\[Integral]", "c", 
                      StyleBox["b",
                        FontSize->14]],
                    FontSize->18], 
                  StyleBox[\(\(f(x)\) \[DifferentialD]x\),
                    FontSize->16]}], 
                StyleBox["=",
                  FontSize->16], " ", 
                RowBox[{
                  StyleBox[\(lim\_\(x \[Rule] b\)\),
                    FontSize->16], 
                  StyleBox[" ",
                    FontSize->18], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox["\[Integral]", "c", 
                        StyleBox["x",
                          FontSize->14]],
                      FontSize->18], 
                    StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                      FontSize->16]}]}]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  "\t\t\t\nCuando dicho l\[IAcute]mite no existe se dice que la ",
  StyleBox["integral de f no es convergente",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. En los casos en que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(lim\_\(x \[Rule] b\)\),
              FontSize->16], 
            StyleBox[" ",
              FontSize->18], 
            RowBox[{
              StyleBox[
                SubsuperscriptBox["\[Integral]", "c", 
                  StyleBox["x",
                    FontSize->14]],
                FontSize->18], 
              StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                FontSize->16]}]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(-\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ", o ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(lim\_\(x \[Rule] b\)\),
              FontSize->16], 
            StyleBox[" ",
              FontSize->18], 
            RowBox[{
              StyleBox[
                SubsuperscriptBox["\[Integral]", "c", 
                  StyleBox["x",
                    FontSize->14]],
                FontSize->18], 
              StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                FontSize->16]}]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(+\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ", se dice que  la ",
  StyleBox["integral de f es negativamente, o positivamente, divergente",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ y, simb\[OAcute]licamente, escribimos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "c", 
                StyleBox["b",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(-\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ", o ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "c", 
                StyleBox["b",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(+\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ". "
}], "Text",
  FontSize->16],

Cell["Obervaciones sobre la terminolog\[IAcute]a usual", "Subsection"],

Cell[TextData[{
  "Las integrales que acabamos de definir se llaman ",
  StyleBox["\"integrales impropias de Riemann\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[".",
    FontSlant->"Italic"],
  " En este sentido se habla usualmente de la ",
  StyleBox["\"convergencia de la integral impropia de Riemann\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " o del ",
  StyleBox["\"valor de la",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["integral impropia de Riemann\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " o se dice que ",
  StyleBox[" \"f es impropiamente integrable Riemann\"",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Es bueno que conozcas esta terminolog\[IAcute]a porque es la que emplean \
casi todos los textos, pero no olvides que es tan s\[OAcute]lo una manera de \
hablar y que los conceptos a los que se refiere son los que acabamos de \
definir. ",
  StyleBox["En mi opini\[OAcute]n esta terminolog\[IAcute]a es bastante \
farragosa e innecesaria por lo que, en adelante, no la usaremos.",
    FontSlant->"Italic"],
  "\n\nSeg\[UAcute]n la definici\[OAcute]n anterior,  para estudiar la \
convergencia de una integral basta con estudiar el l\[IAcute]mite de una \
primitiva de ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", pues eso es la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(F(x)\), "=", 
          StyleBox[" ",
            FontSize->18], 
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "c", 
                StyleBox["x",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}]}], TraditionalForm]]],
  ". Si  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " tiene en el intervalo [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[  una primitiva, ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", que se expresa por medio de funciones elementales, y tenemos la suerte \
de conocerla, es posible calcular, con las t\[EAcute]cnicas usuales, el valor \
del l\[IAcute]mite ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(lim\_\(x \[Rule] b\)F(x)\)\)\)]],
  ". Veamos algunos ejemplos."
}], "Body",
  FontSize->16],

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  StyleBox["i)",
    FontWeight->"Bold"],
  " Si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] \[NotEqual] \(-1\)\)]],
  ",  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "1", 
                StyleBox["x",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", " ", 
          RowBox[{
            FractionBox[
              StyleBox[\(x\^\(\(\ \)\(\[Alpha] + 1\)\)\),
                FontSize->16], 
              StyleBox[\(\[Alpha]\  + \ 1\),
                FontSize->16]], " ", "-", " ", 
            FractionBox[
              StyleBox["1",
                FontSize->16], 
              StyleBox[\(\[Alpha]\  + \ 1\),
                FontSize->16]]}]}], TraditionalForm]],
    FontSize->16],
  ". Deducimos que si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 < 0\)]],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_1\%\(+\[Infinity]\)\),
              FontSize->18], 
            StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \[DifferentialD]t\),
              FontSize->16]}], "=", 
          RowBox[{
            RowBox[{\(lim\_\(x \[Rule] \(+\[Infinity]\)\)\), 
              FormBox[
                RowBox[{
                  RowBox[{
                    StyleBox[\(\[Integral]\_1\%x\),
                      FontSize->18], 
                    
                    StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \
\[DifferentialD]t\),
                      FontSize->16]}], "="}],
                "TraditionalForm"]}], "-", 
            FractionBox[
              StyleBox["1",
                FontSize->16], 
              StyleBox[\(\[Alpha]\  + \ 1\),
                FontSize->16]]}]}], TraditionalForm]],
    FontSize->16],
  ", y si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 > 0\)]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_1\%\(+\[Infinity]\)\),
              FontSize->18], 
            StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(+\[Infinity]\),
            FontSize->16]}], TraditionalForm]],
    FontSize->16],
  ".\nAn\[AAcute]logamente, si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 > 0\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_\(\(\ \)\(0\)\)\%1\),
              FontSize->18], 
            StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", " ", 
          RowBox[{\(lim\_\(x \[Rule] 0\)\), 
            RowBox[{
              FormBox[
                RowBox[{
                  RowBox[{
                    StyleBox[\(\[Integral]\_x\%1\),
                      FontSize->18], 
                    
                    StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \
\[DifferentialD]t\),
                      FontSize->16]}], "="}],
                "TraditionalForm"], 
              FractionBox[
                StyleBox["1",
                  FontSize->16], 
                StyleBox[\(\[Alpha]\  + \ 1\),
                  FontSize->16]]}]}]}], TraditionalForm]],
    FontSize->16],
  ", y si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 < 0\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_\(\(\ \)\(0\)\)\%1\),
              FontSize->18], 
            StyleBox[\(\(t\^\(\(\ \)\(\[Alpha]\)\)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", \(+\[Infinity]\)}], TraditionalForm]],
    FontSize->16],
  ".\n",
  StyleBox["ii) ",
    FontWeight->"Bold"],
  "Usando la t\[EAcute]cnica de integraci\[OAcute]n por partes, que \
estudiaremos m\[AAcute]s adelante, es f\[AAcute]cil calcular una primitiva de \
la funci\[OAcute]n  \n",
  Cell[BoxData[
      FormBox[
        RowBox[{\(f(x)\), "=", 
          FormBox[
            StyleBox[\(\(x\^\[Alpha]\) log\ x\),
              FontSize->16],
            "TraditionalForm"]}], TraditionalForm]]],
  " donde  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] \[NotEqual] \(-1\)\)]],
  ". Comprueba que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"  ", 
          RowBox[{\(F(x)\), "=", 
            FractionBox[
              RowBox[{
                StyleBox[\(x\^\(1 + \[Alpha]\)\),
                  FontSize->16], 
                StyleBox[" ",
                  FontSize->16], 
                RowBox[{"(", 
                  
                  StyleBox[\(\(-1\)\  + \ \((1\  + \ \[Alpha])\)\ \(log(
                          x)\)\),
                    FontSize->16], 
                  StyleBox[")",
                    FontSize->16]}]}], 
              StyleBox[\(\((1\  + \ \[Alpha])\)\^2\),
                FontSize->16]]}]}], TraditionalForm]]],
  " es una primitiva de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^+\)\)]],
  ". Por tanto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "1", 
                StyleBox["x",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\[Alpha]\) log\ t \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", " ", \(F(x)\  - F(1)\)}], TraditionalForm]],
    FontSize->16],
  ". En consecuencia, si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 < 0\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "1", 
                StyleBox[\(+\[Infinity]\),
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\[Alpha]\) log\ t \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", 
          RowBox[{\(-\(F(1)\)\), "=", 
            FractionBox[
              StyleBox["1",
                FontSize->16], 
              SuperscriptBox[
                RowBox[{"(", 
                  StyleBox[\(\[Alpha]\  + \ 1\),
                    FontSize->16], 
                  StyleBox[")",
                    FontSize->16]}], \(\(\ \)\(2\)\)]]}]}], TraditionalForm]],
    
    FontSize->16],
  ", y si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 > 0\)]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "1", 
                StyleBox[\(+\[Infinity]\),
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\[Alpha]\) log\ t \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", \(+\[Infinity]\)}], TraditionalForm]],
    FontSize->16],
  ".\nAn\[AAcute]logamente, si  ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 > 0\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                StyleBox["1",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\[Alpha]\) log\ t \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", " ", 
          RowBox[{\(lim\_\(x \[Rule] 0\)\((F(1) - F(x))\)\), "=", 
            RowBox[{\(F(1)\), "=", 
              RowBox[{"-", 
                FractionBox[
                  StyleBox["1",
                    FontSize->16], 
                  SuperscriptBox[
                    RowBox[{"(", 
                      StyleBox[\(\[Alpha]\  + \ 1\),
                        FontSize->16], 
                      StyleBox[")",
                        FontSize->16]}], \(\(\ \)\(2\)\)]]}]}]}]}], 
        TraditionalForm]],
    FontSize->16],
  ", y si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + 1 < 0\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                StyleBox["1",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(t\^\[Alpha]\) log\ t \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox[" ",
            FontSize->16], "=", \(-\[Infinity]\)}], TraditionalForm]]],
  ". "
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " conoce estos resultados como puedes comprobar con la orden \
Integrate[f[x],{x,a,b}] que calcula la integral de la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en el intervalo de extremos ",
  StyleBox["a",
    FontSlant->"Italic"],
  " y ",
  StyleBox["b",
    FontSlant->"Italic"],
  ". Cuando la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " tiene adem\[AAcute]s de la variable un par\[AAcute]metro, ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "da el resultado m\[AAcute]s general imponiendo, si es necesario, \
condiciones sobre el par\[AAcute]metro. En esta situaci\[OAcute]n tambi\
\[EAcute]n podemos informar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de que el par\[AAcute]metro satisface ciertas condiciones previas; por \
ejemplo, que es un n\[UAcute]mero real (por defecto, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trata los par\[AAcute]metros como n\[UAcute]meros complejos). "
}], "Text",
  FontSize->16],

Cell[BoxData[
    \(Integrate[x\^\[Alpha], {x, 1, \(+\[Infinity]\)}, 
      Assumptions \[Rule] Im[\[Alpha]] \[Equal] 0]\)], "Input"],

Cell[BoxData[
    \(Integrate[x\^\[Alpha], {x, 0, 1}, 
      Assumptions \[Rule] Im[\[Alpha]] \[Equal] 0]\)], "Input"],

Cell[BoxData[
    \(Integrate[x\^\[Alpha]\ Log[x], {x, 1, \(+\[Infinity]\)}, 
      Assumptions \[Rule] Im[\[Alpha]] \[Equal] 0]\)], "Input"],

Cell[BoxData[
    \(Integrate[x\^\[Alpha]\ Log[x], {x, 0, 1}, 
      Assumptions \[Rule] Im[\[Alpha]] \[Equal] 0]\)], "Input"],

Cell["\<\
Naturalmente, no siempre vamos a disponer de una primitiva expresable por \
medio de funciones elementales, bien porque no exista o porque su \
c\[AAcute]lculo efectivo sea muy complicado. Por ello, interesa conocer \
condiciones que aseguren la convergencia de una integral sin necesidad de \
conocer una primitiva elemental. L\[OAcute]gicamente, estas condiciones no \
nos permitar\[AAcute]n calcular el valor num\[EAcute]rico de la integral; tan \
s\[OAcute]lo nos dir\[AAcute]n si es o no convergente. El caso en que la \
funci\[OAcute]n integrando es positiva es particularmente sencillo de \
estudiar.\
\>", "Text",
  FontSize->16],

Cell["Criterio b\[AAcute]sico de convergencia ", "Subsection"],

Cell[TextData[{
  "Sea  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " continua y ",
  StyleBox["positiva",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. Entonces, la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ es convergente si, y s\[OAcute]lo si, la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{\(F(x)\), "=", 
              StyleBox[" ",
                FontSize->18], 
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", "c", 
                    StyleBox["x",
                      FontSize->14]],
                  FontSize->18], 
                StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                  FontSize->16]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  " est\[AAcute] mayorada en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[, en cuyo caso ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", "c", 
                    StyleBox["b",
                      FontSize->14]],
                  FontSize->18], 
                StyleBox[\(\(f(x)\) \[DifferentialD]x\),
                  FontSize->16]}], 
              StyleBox["=",
                FontSize->16], 
              RowBox[{"sup", 
                RowBox[{
                  StyleBox["{",
                    FontSize->24,
                    FontColor->GrayLevel[0]], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox["\[Integral]", "c", 
                        StyleBox["x",
                          FontSize->14]],
                      FontSize->18], 
                    
                    StyleBox[\(\(f(
                          t)\) \[DifferentialD]\(t : c \[LessEqual] x < b\)\),
                      
                      FontSize->16]}], 
                  StyleBox[" ",
                    FontSize->16], 
                  StyleBox["}",
                    FontSize->24]}]}]}],
            "TraditionalForm"]}], TraditionalForm]]],
  ". En otro caso la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ es positivamente divergente."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "La afirmaci\[OAcute]n anterior es consecuencia de que por ser ",
  StyleBox["f",
    FontSlant->"Italic"],
  " positiva",
  " la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        FormBox[
          RowBox[{\(F(x)\), "=", 
            StyleBox[" ",
              FontSize->18], 
            RowBox[{
              StyleBox[
                SubsuperscriptBox["\[Integral]", "c", 
                  StyleBox["x",
                    FontSize->14]],
                FontSize->18], 
              StyleBox[\(\(f(t)\) \[DifferentialD]t\),
                FontSize->16]}]}],
          "TraditionalForm"], TraditionalForm]]],
  " es creciente. El siguiente criterio de convergencia es consecuencia f\
\[AAcute]cil del anterior."
}], "Text",
  FontSize->16],

Cell["Criterio de comparaci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Sean  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y ",
  StyleBox["g",
    FontSlant->"Italic"],
  " continuas y ",
  StyleBox["positivas",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. Supongamos que la integral de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ es convergente y que  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(f(x) \[LessEqual] g(x)\),
          FontSize->16], TraditionalForm]]],
  " para todo ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c, b",
    FontSlant->"Italic"],
  "[. Entonces la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ tambi\[EAcute]n es convergente."
}], "Text",
  FontSize->16],

Cell["Criterio l\[IAcute]mite de comparaci\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Sean  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y ",
  StyleBox["g",
    FontSlant->"Italic"],
  " continuas y ",
  StyleBox["positivas",
    FontSlant->"Italic"],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[. Supongamos que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(lim\_\(x \[Rule] b\)\),
              FontSize->16], 
            FractionBox[
              StyleBox[\(f(x)\),
                FontSize->16], 
              StyleBox[\(g(x)\),
                FontSize->16]]}], "=", \(\[Lambda] \[NotEqual] 0\)}], 
        TraditionalForm]]],
  ". Entonces las integrales de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ ambas convergen o ambas divergen positivamente."
}], "Text",
  FontSize->16],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Sea  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " continua en ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[ donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Infinity]\) \[LessEqual] a < 
        b \[LessEqual] \(+\[Infinity]\)\)],
    FontSize->16],
  ", y sea ",
  StyleBox["c\[Element]",
    FontSlant->"Italic"],
  "]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[. Si  la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es convergente en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ y en ]",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "], se dice que la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " ",
  StyleBox["es convergente",
    FontSlant->"Italic"],
  " en ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[ y se define su valor como el n\[UAcute]mero ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "a", 
                StyleBox["b",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(x)\) \[DifferentialD]x\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          RowBox[{
            RowBox[{
              StyleBox[
                SubsuperscriptBox["\[Integral]", "a", 
                  StyleBox["c",
                    FontSize->14]],
                FontSize->18], 
              StyleBox[\(\(f(x)\) \[DifferentialD]x\),
                FontSize->16]}], 
            StyleBox["+",
              FontSize->16], 
            RowBox[{
              StyleBox[
                SubsuperscriptBox["\[Integral]", "c", 
                  StyleBox["b",
                    FontSize->14]],
                FontSize->18], 
              StyleBox[\(\(f(x)\) \[DifferentialD]x\),
                FontSize->16]}]}]}], TraditionalForm]]],
  ". En el caso de que alguna de las integrales de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ]",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "] o en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ no sea convergente se dice que la ",
  StyleBox["integral de f no es convergente",
    FontSlant->"Italic"],
  " en ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[. En el caso de que las integrales de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ]",
  StyleBox["a,c",
    FontSlant->"Italic"],
  "] y en [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[ sean ambas positivamente divergentes o una convergente y otra \
positivamente divergente, se dice que la ",
  StyleBox["integral de f es  positivamente divergente",
    FontSlant->"Italic"],
  " en ]",
  StyleBox["a,b",
    FontSlant->"Italic"],
  "[ y, simb\[OAcute]licamente, escribimos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "a", 
                StyleBox["b",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(+\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ". An\[AAcute]logo significado tiene la expresi\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", "a", 
                StyleBox["b",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[\(\(f(t)\) \[DifferentialD]t\),
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          StyleBox[\(-\[Infinity]\),
            FontSize->16]}], TraditionalForm]]],
  ".\t\t\t\t\t"
}], "Text",
  FontSize->16],

Cell["Ejemplos", "Subsection"],

Cell[TextData[{
  StyleBox["i)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(-\[Infinity]\), 
                StyleBox[\(+\[Infinity]\),
                  FontSize->14]],
              FontSize->18], 
            StyleBox[
              RowBox[{
                FractionBox[
                  StyleBox["1",
                    FontSize->16], 
                  StyleBox[\(1\  + \ x\^2\),
                    FontSize->16]], \(\[DifferentialD]x\)}],
              FontSize->16]}], 
          StyleBox["=",
            FontSize->16], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", \(-\[Infinity]\), 
                    RowBox[{" ", 
                      StyleBox["0",
                        FontSize->14]}]],
                  FontSize->18], 
                StyleBox[
                  RowBox[{
                    FractionBox[
                      StyleBox["1",
                        FontSize->16], 
                      RowBox[{
                        StyleBox["1",
                          FontSize->16], 
                        StyleBox[" ",
                          FontSize->16], "+", " ", 
                        StyleBox[\(x\^2\),
                          FontSize->16]}]], \(\[DifferentialD]x\)}],
                  FontSize->16]}], 
              StyleBox["+",
                FontSize->16], 
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                    StyleBox[\(+\[Infinity]\),
                      FontSize->14]],
                  FontSize->18], 
                StyleBox[
                  RowBox[{
                    FractionBox[
                      StyleBox["1",
                        FontSize->16], 
                      RowBox[{
                        StyleBox["1",
                          FontSize->16], 
                        StyleBox[" ",
                          FontSize->16], "+", " ", 
                        StyleBox[\(x\^2\),
                          FontSize->16]}]], \(\[DifferentialD]x\)}],
                  FontSize->16]}]}], 
            StyleBox[" ",
              FontSize->16], 
            StyleBox["=",
              FontSize->16], " ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(t \[Rule] \(-\[Infinity]\)\),
                          FontSize->12]}]],
                    FontSize->16], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox["\[Integral]", 
                        RowBox[{" ", 
                          StyleBox["t",
                            FontSize->14]}], 
                        RowBox[{" ", 
                          StyleBox["0",
                            FontSize->14]}]],
                      FontSize->18], 
                    StyleBox[
                      RowBox[{
                        FractionBox[
                          StyleBox["1",
                            FontSize->16], 
                          RowBox[{
                            StyleBox["1",
                              FontSize->16], 
                            StyleBox[" ",
                              FontSize->16], "+", " ", 
                            StyleBox[\(x\^2\),
                              FontSize->16]}]], \(\[DifferentialD]x\)}],
                      FontSize->16]}]}], 
                StyleBox[" ",
                  FontSize->16], 
                StyleBox["+",
                  FontSize->16], " ", 
                RowBox[{
                  StyleBox[
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(s \[Rule] \(+\[Infinity]\)\),
                          FontSize->12]}]],
                    FontSize->16], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                        RowBox[{" ", 
                          StyleBox["s",
                            FontSize->14]}]],
                      FontSize->18], 
                    StyleBox[
                      RowBox[{
                        FractionBox[
                          StyleBox["1",
                            FontSize->16], 
                          RowBox[{
                            StyleBox["1",
                              FontSize->16], 
                            StyleBox[" ",
                              FontSize->16], "+", " ", 
                            StyleBox[\(x\^2\),
                              FontSize->16]}]], \(\[DifferentialD]x\)}],
                      FontSize->16]}]}]}], 
              StyleBox[" ",
                FontSize->16], 
              StyleBox["=",
                FontSize->16], 
              StyleBox[" ",
                FontSize->16]}]}]}], TraditionalForm]]],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            RowBox[{" ", 
              StyleBox[" ",
                FontSize->16]}]], 
          StyleBox[
            RowBox[{"=", " ", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(t \[Rule] \(-\[Infinity]\)\),
                          FontSize->12]}]], \((arctg\ 0\  - arctag\ t)\)}], 
                  " ", "+", "   ", 
                  RowBox[{
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(s \[Rule] \(+\[Infinity]\)\),
                          FontSize->12]}]], \((arctg\ s\  - arctag\ 0)\)}]}], 
                " ", "=", \(\[Pi]/2\  + \ \[Pi]/
                      2 = \(\(\[Pi]\)\(\ \)\(.\)\)\)}]}],
            FontSize->16]}], TraditionalForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["ii)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                StyleBox[\(+\[Infinity]\),
                  FontSize->14]],
              FontSize->18], 
            RowBox[{
              SuperscriptBox[
                StyleBox["x",
                  FontSize->16], "\[Alpha]"], 
              StyleBox[\(\[DifferentialD]x\),
                FontSize->16]}]}], 
          StyleBox["=",
            FontSize->16], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", \(\(\ \)\(0\)\), 
                    StyleBox["1",
                      FontSize->14]],
                  FontSize->18], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox["x",
                      FontSize->16], "\[Alpha]"], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontSize->16]}]}], 
              StyleBox["+",
                FontSize->16], 
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", \(\(\ \)\(1\)\), 
                    StyleBox[\(+\[Infinity]\),
                      FontSize->14]],
                  FontSize->18], 
                RowBox[{
                  SuperscriptBox[
                    StyleBox["x",
                      FontSize->16], "\[Alpha]"], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontSize->16]}]}]}], 
            StyleBox["=",
              FontSize->16], 
            StyleBox[\(+\[Infinity]\),
              FontSize->16]}]}], TraditionalForm]]],
  " porque una de las dos integrales converge y la otra diverge \
positivamente."
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["iii)",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  FontSize->14], \(-1\), 
                StyleBox["1",
                  FontSize->14]],
              FontSize->18], 
            StyleBox[
              RowBox[{
                FractionBox[
                  StyleBox["1",
                    FontSize->16], 
                  StyleBox[
                    SqrtBox[
                      StyleBox[\(1\  - \ x\^2\),
                        FontSize->16]],
                    FontSize->16]], \(\[DifferentialD]x\)}],
              FontSize->16]}], 
          StyleBox["=",
            FontSize->14], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  SubsuperscriptBox[
                    StyleBox["\[Integral]",
                      FontSize->14], \(-1\), 
                    StyleBox["0",
                      FontSize->14]],
                  FontSize->18], 
                RowBox[{
                  StyleBox[
                    FractionBox[
                      StyleBox["1",
                        FontSize->16], 
                      StyleBox[
                        SqrtBox[
                          StyleBox[\(1\  - \ x\^2\),
                            FontSize->16]],
                        FontSize->16]],
                    FontSize->16], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontSize->14]}]}], 
              StyleBox["+",
                FontSize->16], 
              RowBox[{
                StyleBox[
                  SubsuperscriptBox[
                    StyleBox["\[Integral]",
                      FontSize->14], \(\(\ \)\(0\)\), 
                    StyleBox["1",
                      FontSize->14]],
                  FontSize->18], 
                RowBox[{
                  StyleBox[
                    FractionBox[
                      StyleBox["1",
                        FontSize->14], 
                      StyleBox[
                        SqrtBox[
                          StyleBox[\(1\  - \ x\^2\),
                            FontSize->16]],
                        FontSize->16]],
                    FontSize->16], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontSize->14]}]}]}], 
            StyleBox["=",
              FontSize->16], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(t \[Rule] \(-1\)\),
                          FontSize->12]}]],
                    FontSize->16], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox[
                        StyleBox["\[Integral]",
                          FontSize->14], 
                        RowBox[{" ", 
                          StyleBox["t",
                            FontSize->14]}], 
                        StyleBox["0",
                          FontSize->14]],
                      FontSize->18], 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSize->16], 
                          StyleBox[
                            SqrtBox[
                              StyleBox[\(1\  - \ x\^2\),
                                FontSize->16]],
                            FontSize->16]],
                        FontSize->16], 
                      StyleBox[\(\[DifferentialD]x\),
                        FontSize->14]}]}]}], 
                StyleBox["+",
                  FontSize->16], 
                RowBox[{
                  StyleBox[
                    SubscriptBox["lim", 
                      RowBox[{" ", 
                        StyleBox[\(s \[Rule] 1\),
                          FontSize->12]}]],
                    FontSize->16], 
                  RowBox[{
                    StyleBox[
                      SubsuperscriptBox[
                        StyleBox["\[Integral]",
                          FontSize->14], \(\(\ \)\(0\)\), 
                        RowBox[{" ", 
                          StyleBox["s",
                            FontSize->14]}]],
                      FontSize->18], 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSize->16], 
                          StyleBox[
                            SqrtBox[
                              StyleBox[\(1\  - \ x\^2\),
                                FontSize->16]],
                            FontSize->16]],
                        FontSize->16], 
                      StyleBox[\(\[DifferentialD]x\),
                        FontSize->14]}]}]}]}], 
              StyleBox["=",
                FontSize->14]}]}]}], TraditionalForm]]],
  "\n",
  Cell[BoxData[
      FormBox[
        RowBox[{"=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox[
                  SubscriptBox["lim", 
                    RowBox[{" ", 
                      StyleBox[\(t \[Rule] \(-1\)\),
                        FontSize->12]}]],
                  FontSize->16], \((arcsen\ 0\  - arcsen\ t)\)}], 
              StyleBox["+",
                FontSize->16], 
              RowBox[{
                StyleBox[
                  SubscriptBox["lim", 
                    RowBox[{" ", 
                      StyleBox[\(s \[Rule] 1\),
                        FontSize->12]}]],
                  FontSize->16], \((arcsen\ s\  - \ arcsen\ 0)\)}]}], "=", 
            StyleBox[\(\[Pi]/2\  + \ \[Pi]/2 = \(\(\[Pi]\)\(\ \)\(.\)\)\),
              FontSize->16]}]}], TraditionalForm]]]
}], "Text",
  FontSize->16],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Es f\[AAcute]cil ahora asociar \[AAcute]rea a regiones no acotadas del \
plano de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["G",
            FontSize->16], 
          StyleBox["(",
            FontSize->16], 
          RowBox[{
            StyleBox["f",
              FontSize->16], 
            StyleBox[",",
              FontSize->16], 
            StyleBox["c",
              FontSize->16], 
            StyleBox[",",
              FontSize->16,
              FontSlant->"Italic"], 
            StyleBox["b",
              FontSize->16,
              FontSlant->"Italic"]}], 
          StyleBox[")",
            FontSize->16,
            FontSlant->"Italic"]}], TraditionalForm]]],
  "donde  ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{
            FormBox[\(\(-\[Infinity]\) < c\),
              "TraditionalForm"], "<", 
            FormBox[
              StyleBox[\(b \[LessEqual] \(+\[Infinity]\)\),
                FontSize->16],
              "TraditionalForm"]}],
          FontSize->16], TraditionalForm]]],
  " y  ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es una funci\[OAcute]n continua en el intervalo [",
  StyleBox["c,b",
    FontSlant->"Italic"],
  "[",
  StyleBox[".",
    FontSlant->"Italic"],
  " Para ello, basta tomar l\[IAcute]mites en la igualdad ",
  Cell[BoxData[
      FormBox[
        FormBox[
          RowBox[{
            StyleBox["  ",
              FontSize->16], 
            RowBox[{
              RowBox[{"\[Lambda]", "(", 
                RowBox[{"G", "(", 
                  RowBox[{
                    StyleBox["f",
                      FontSize->16], 
                    StyleBox[",",
                      FontSize->16], 
                    StyleBox["c",
                      FontSize->16], 
                    StyleBox[",",
                      FontSize->16,
                      FontSlant->"Italic"], 
                    StyleBox["t",
                      FontSize->16,
                      FontSlant->"Italic"]}], 
                  StyleBox[")",
                    FontSize->16,
                    FontSlant->"Italic"]}], 
                StyleBox[")",
                  FontSize->16,
                  FontSlant->"Italic"]}], "=", 
              RowBox[{
                StyleBox[
                  SubsuperscriptBox["\[Integral]", "c", 
                    StyleBox["t",
                      FontSize->14]],
                  FontSize->18], 
                RowBox[{
                  StyleBox["|",
                    FontSize->18], 
                  StyleBox[\(f(x)\),
                    FontSize->16], 
                  StyleBox["|",
                    FontSize->16], 
                  StyleBox[\(\[DifferentialD]x\),
                    FontSize->16]}]}]}]}],
          "TraditionalForm"], TraditionalForm]]],
  ". Llegamos as\[IAcute] a la definici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Lambda]", "(", 
            RowBox[{"G", "(", 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["c",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}], 
            StyleBox[")",
              FontSize->16,
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            StyleBox[\(\[Integral]\_c\%b\),
              FontSize->18], 
            RowBox[{
              StyleBox["|",
                FontSize->18], 
              StyleBox[\(f(x)\),
                FontSize->16], 
              StyleBox["|",
                FontSize->16], 
              StyleBox[\(\[DifferentialD]x\),
                FontSize->16]}]}]}], TraditionalForm]]],
  ". En el caso de una regi\[OAcute]n del tipo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["G",
            FontSize->16], 
          StyleBox["(",
            FontSize->16], 
          RowBox[{
            StyleBox["f",
              FontSize->16], 
            StyleBox[",",
              FontSize->16], 
            StyleBox["a",
              FontSize->16,
              FontSlant->"Italic"], 
            StyleBox[",",
              FontSize->16,
              FontSlant->"Italic"], 
            StyleBox["b",
              FontSize->16,
              FontSlant->"Italic"]}], 
          StyleBox[")",
            FontSize->16,
            FontSlant->"Italic"]}], TraditionalForm]]],
  ", como la considerada en la definici\[OAcute]n anterior, basta tener en \
cuenta que si ",
  Cell[BoxData[
      \(TraditionalForm\`a < c < b\)]],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["G",
              FontSize->16], 
            StyleBox["(",
              FontSize->16], 
            RowBox[{
              StyleBox["f",
                FontSize->16], 
              StyleBox[",",
                FontSize->16], 
              StyleBox["a",
                FontSize->16,
                FontSlant->"Italic"], 
              StyleBox[",",
                FontSize->16,
                FontSlant->"Italic"], 
              StyleBox["b",
                FontSize->16,
                FontSlant->"Italic"]}], 
            StyleBox[")",
              FontSize->16,
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{
              StyleBox["G",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["a",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["c",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}], "\[Union]", 
            RowBox[{
              StyleBox["G",
                FontSize->16], 
              StyleBox["(",
                FontSize->16], 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["c",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}]}]}], TraditionalForm]]],
  " por lo que definimos, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[Lambda]", "(", 
            RowBox[{"G", "(", 
              RowBox[{
                StyleBox["f",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16], 
                StyleBox["a",
                  FontSize->16], 
                StyleBox[",",
                  FontSize->16,
                  FontSlant->"Italic"], 
                StyleBox["b",
                  FontSize->16,
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontSize->16,
                FontSlant->"Italic"]}], 
            StyleBox[")",
              FontSize->16,
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            StyleBox[\(\[Integral]\_a\%c\),
              FontSize->18], 
            RowBox[{
              StyleBox["|",
                FontSize->18], 
              StyleBox[\(f(x)\),
                FontSize->16], 
              StyleBox["|",
                FontSize->16], 
              StyleBox[\(\(\[DifferentialD]x\)\(+\)\),
                FontSize->16]}]}]}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Integral]\_c\%b\),
            FontSize->18], 
          RowBox[{
            StyleBox["|",
              FontSize->18], 
            StyleBox[\(f(x)\),
              FontSize->16], 
            StyleBox["|",
              FontSize->16], 
            StyleBox[\(\[DifferentialD]x\),
              FontSize->16]}]}], TraditionalForm]]],
  Cell[BoxData[
      FormBox[
        RowBox[{"=", 
          RowBox[{
            StyleBox[\(\[Integral]\_a\%b\),
              FontSize->18], 
            RowBox[{
              StyleBox["|",
                FontSize->18], 
              StyleBox[\(f(x)\),
                FontSize->16], 
              StyleBox["|",
                FontSize->16], 
              StyleBox[\(\[DifferentialD]x\),
                FontSize->16]}]}]}], TraditionalForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "Si la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " toma valores positivos y negativos, puede ocurrir que la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sea convergente y la integral de la funci\[OAcute]n | ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "| no lo sea. El siguiente es un ejemplo de esta situaci\[OAcute]n. "
}], "Text",
  FontSize->16],

Cell[BoxData[{
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(\(f[0] = 1;\)\), "\[IndentingNewLine]", 
    \(\(f[x_] := 
        Sin[x]/x\ \  /; x \[NotEqual] 0;\)\), "\[IndentingNewLine]", 
    \(\(Show[{graford[f[x], {x, 0, 14}, PlotRange -> {\(- .22\), 1}], 
          graford[Abs[f[x]], {x, 0, 14}, PlotRange -> {\(- .22\), 1}]}, 
        DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f];\)\)}], "Input"],

Cell[TextData[{
  "La integral de la funci\[OAcute]n anterior es convergente en [0,+\
\[Infinity][. Puedes pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que la calcule."
}], "Text",
  FontSize->16],

Cell[BoxData[
    \(Integrate[Sin[x]/x, {x, 0, \(+\[Infinity]\)}]\)], "Input"],

Cell[TextData[{
  "Sin embargo se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox["\[Integral]",
                FontSize->18], \(\(\ \)\(0\)\), \(\(+\[Infinity]\)\(\ \)\)], 
            RowBox[{"|", 
              FractionBox[
                StyleBox[\(sen\ x\),
                  FontSize->16], 
                StyleBox["x",
                  FontSize->16]], "|", \(\[DifferentialD]x\)}]}], 
          "=", \(+\[Infinity]\)}], TraditionalForm]]],
  ". Ello es consecuencia de que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"|", 
          FractionBox[
            StyleBox[\(sen\ x\),
              FontSize->16], 
            StyleBox["x",
              FontSize->16]], 
          "|", \(\(\[GreaterEqual]\)\(\ \)\(1\/\(\((k + 1)\)\ \[Pi]\)\)\), 
          "|", \(sen\ x\), "|"}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k\ \[Pi] \[LessEqual] 
        x \[LessEqual] \((k + 1)\)\ \[Pi]\)]],
  ". Por otra parte ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox["\[Integral]",
                
                FontSize->
                  18], \(\(\ \)\(k\ \[Pi]\)\), \(\((k\  + 
                    1)\) \(\[Pi]\)\(\ \)\)], 
            RowBox[{"|", 
              StyleBox[\(sen\ x\),
                FontSize->16], "|", \(\[DifferentialD]x\)}]}], "=", 
          RowBox[{
            RowBox[{
              SubsuperscriptBox[
                StyleBox["\[Integral]",
                  FontSize->18], \(\(\ \)\(0\)\), \(\(\ \)\(\[Pi]\)\(\ \)\)], 
              
              RowBox[{"|", 
                StyleBox[\(sen\ x\),
                  FontSize->16], "|", \(\[DifferentialD]x\)}]}], "=", "2"}]}],
         TraditionalForm]]],
  ". Deducimos que: \n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox["\[Integral]",
                
                FontSize->
                  18], \(\(\ \ \)\(0\)\), \(\(\ \)\(\(n\)\(\ \)\(\[Pi]\)\(\ \
\)\)\)], 
            RowBox[{"|", 
              FractionBox[
                StyleBox[\(sen\ x\),
                  FontSize->16], 
                StyleBox["x",
                  FontSize->16]], "|", \(\[DifferentialD]x\)}]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{\(\[Sum]\+\(k = 0\)\%\(n - 1\)\), 
                  RowBox[{"[", 
                    RowBox[{
                      SubsuperscriptBox[
                        StyleBox["\[Integral]",
                          
                          FontSize->
                            18], \(\(\ \)\(k\ \[Pi]\)\), \(\((k\  + 
                              1)\) \(\[Pi]\)\(\ \)\)], 
                      RowBox[{"|", 
                        FractionBox[
                          StyleBox[\(sen\ x\),
                            FontSize->16], 
                          StyleBox["x",
                            FontSize->16]], "|", \(\[DifferentialD]x\)}]}], 
                    "]"}]}], "\[GreaterEqual]", 
                RowBox[{\(\[Sum]\+\(k = 0\)\%\(n - 1\)\), 
                  RowBox[{
                    FractionBox[
                      StyleBox["1",
                        FontSize->14], 
                      RowBox[{
                        RowBox[{
                          StyleBox["(",
                            FontSize->16], " ", 
                          StyleBox[\(k + 1\),
                            FontSize->14], 
                          StyleBox[")",
                            FontSize->16]}], 
                        StyleBox[" ",
                          FontSize->14], 
                        StyleBox["\[Pi]",
                          FontSize->14]}]], 
                    SubsuperscriptBox[
                      StyleBox["\[Integral]",
                        FontSize->
                          18], \(\(\ \)\(k\ \[Pi]\)\), \(\((k\  + 
                            1)\) \(\[Pi]\)\(\ \)\)]}]}]}], "|", \(sen\ x\), 
              "|", \(\[DifferentialD]x\)}], "=", 
            RowBox[{
              RowBox[{
                FractionBox[
                  StyleBox["2",
                    FontSize->14], 
                  StyleBox["\[Pi]",
                    FontSize->14]], 
                RowBox[{\(\[Sum]\+\(k = 1\)\%n\), 
                  FractionBox[
                    StyleBox["1",
                      FontSize->14], 
                    StyleBox[\(\(k\)\(\ \)\),
                      FontSize->14]]}]}], "\[GreaterEqual]", 
              RowBox[{
                FractionBox[
                  StyleBox["2",
                    FontSize->14], 
                  StyleBox["\[Pi]",
                    FontSize->14]], " ", "log", " ", "n", " "}]}]}]}], 
        TraditionalForm]]],
  "\nde donde se deduce que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubsuperscriptBox[
              StyleBox["\[Integral]",
                FontSize->18], \(\(\ \)\(0\)\), \(\(+\[Infinity]\)\(\ \)\)], 
            RowBox[{"|", 
              FractionBox[
                StyleBox[\(sen\ x\),
                  FontSize->16], 
                StyleBox["x",
                  FontSize->16]], "|", \(\[DifferentialD]x\)}]}], 
          "=", \(+\[Infinity]\)}], TraditionalForm]]],
  ". \nLa situaci\[OAcute]n anterior motiva la siguiente definici\[OAcute]n."
}], "Text",
  FontSize->16],

Cell["Definici\[OAcute]n", "Subsection"],

Cell[TextData[{
  "Se dice que la integral de  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es",
  StyleBox[" absolutamente convergente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en un cierto intervalo cuando la integral de la funci\[OAcute]n | ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "| es convergente en dicho intervalo. \nEn otros t\[EAcute]rminos, la \
integral de  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es absolutamente convergente en un intervalo de extremos ",
  StyleBox["a, b",
    FontSlant->"Italic"],
  " cuando la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(f, a, b)\)]],
  " tiene \[AAcute]rea finita.\nNaturalmente, los criterios de convergencia \
antes vistos para integrales de funciones positivas, pueden usarse para \
estudiar la convergencia absoluta de la integral de cualquier \
funci\[OAcute]n. Por ello, el siguiente resultado, que no demostraremos, es \
de gran utilidad."
}], "Text",
  FontSize->16],

Cell["Teorema", "Subsection"],

Cell[TextData[{
  "Si  la integral de  ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es",
  StyleBox[" absolutamente convergente,",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " entonces la integral de  ",
  StyleBox["f  ",
    FontSlant->"Italic"],
  "tambi\[EAcute]n es convergente."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "F\[IAcute]jate que la integral de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es absolutamente convergente si. y s\[OAcute]lo si, son convergentes las \
integrales de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`f\^\(\(\ \)\(+\)\)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`f\^\(\(\ \)\(-\)\)\)]],
  ", en cuyo caso se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\( f(
              x)\) \[DifferentialD]x = \[Integral]\_a\%b\(\( 
                    f\^\(\(\ \)\(+\)\)\)(
                x)\) \[DifferentialD]x - \[Integral]\_a\%b\(\( 
                    f\^\(\(\ \)\(-\)\)\)(x)\) \[DifferentialD]x\)]],
  "."
}], "Text",
  FontSize->14]
}, Closed]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Working",
CellGrouping->Manual,
WindowSize->{792, 500},
WindowMargins->{{2, Automatic}, {Automatic, 46}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Inherited, Inherited, Inherited}, {Cell[ 
        TextData[ {"Integral de Riemann"}], "Header"], Inherited, 
      Inherited}},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False},
CellLabelAutoDelete->True,
StyleDefinitions -> "DemoJPG.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 61, 1, 90, "Title",
  PageBreakBelow->False],
Cell[1791, 55, 373, 11, 110, "Text",
  PageBreakBelow->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[2201, 71, 38, 0, 84, "Section"],
Cell[2242, 73, 4810, 80, 567, "Text"],
Cell[7055, 155, 212, 3, 51, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7304, 163, 69, 1, 53, "Section",
  InitializationCell->True],
Cell[7376, 166, 89, 2, 42, "Input",
  InitializationCell->True],
Cell[7468, 170, 488, 9, 102, "Input",
  InitializationCell->True],
Cell[7959, 181, 2475, 45, 442, "Input",
  InitializationCell->True],
Cell[10437, 228, 2516, 46, 442, "Input",
  InitializationCell->True],
Cell[12956, 276, 2792, 51, 462, "Input",
  InitializationCell->True],
Cell[15751, 329, 2479, 42, 402, "Input",
  InitializationCell->True],
Cell[18233, 373, 655, 12, 140, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[18925, 390, 35, 0, 53, "Section"],
Cell[18963, 392, 677, 24, 53, "Text"],
Cell[19643, 418, 30, 0, 42, "Subsection"],
Cell[19676, 420, 435, 13, 52, "Text"],
Cell[20114, 435, 70, 1, 42, "Input"],
Cell[20187, 438, 152, 2, 42, "Input"],
Cell[20342, 442, 2547, 61, 300, "Text"],
Cell[22892, 505, 76, 0, 42, "Subsection"],
Cell[22971, 507, 3621, 110, 271, "Text"],
Cell[26595, 619, 604, 10, 162, "Input"],
Cell[27202, 631, 2548, 77, 202, "Text"],
Cell[29753, 710, 40, 0, 42, "Subsection"],
Cell[29796, 712, 1217, 46, 124, "Text"],
Cell[31016, 760, 35, 0, 42, "Subsection"],
Cell[31054, 762, 2270, 66, 256, "Text"],
Cell[33327, 830, 30, 0, 42, "Subsection"],
Cell[33360, 832, 1673, 53, 112, "Text"],
Cell[35036, 887, 74, 1, 42, "Input"],
Cell[35113, 890, 84, 1, 42, "Input"],
Cell[35200, 893, 40, 0, 42, "Subsection"],
Cell[35243, 895, 2558, 90, 196, "Text"],
Cell[37804, 987, 35, 0, 42, "Subsection"],
Cell[37842, 989, 1307, 44, 158, "Text"],
Cell[39152, 1035, 30, 0, 42, "Subsection"],
Cell[39185, 1037, 1341, 47, 92, "Text"],
Cell[40529, 1086, 74, 1, 42, "Input"],
Cell[40606, 1089, 84, 1, 42, "Input"],
Cell[40693, 1092, 242, 8, 34, "Text"],
Cell[40938, 1102, 74, 1, 42, "Input"],
Cell[41015, 1105, 84, 1, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[41136, 1111, 84, 1, 53, "Section"],
Cell[41223, 1114, 2484, 81, 159, "Text"],
Cell[43710, 1197, 40, 0, 42, "Subsection"],
Cell[43753, 1199, 5101, 163, 253, "Text"],
Cell[48857, 1364, 35, 0, 42, "Subsection"],
Cell[48895, 1366, 2896, 75, 305, "Text"],
Cell[51794, 1443, 126, 3, 42, "Input"],
Cell[51923, 1448, 92, 1, 42, "Input"],
Cell[52018, 1451, 152, 4, 42, "Input"],
Cell[52173, 1457, 122, 3, 42, "Input"],
Cell[52298, 1462, 129, 4, 33, "Text"],
Cell[52430, 1468, 68, 0, 42, "Subsection"],
Cell[52501, 1470, 1211, 39, 91, "Text"],
Cell[53715, 1511, 414, 9, 78, "Text"],
Cell[54132, 1522, 288, 6, 57, "Text"],
Cell[54423, 1530, 83, 1, 42, "Subsection"],
Cell[54509, 1533, 1012, 38, 122, "Text"],
Cell[55524, 1573, 596, 20, 53, "Text"],
Cell[56123, 1595, 1322, 40, 72, "Text"],
Cell[57448, 1637, 74, 0, 42, "Subsection"],
Cell[57525, 1639, 4495, 164, 446, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[62057, 1808, 61, 0, 53, "Section"],
Cell[62121, 1810, 4893, 148, 237, "Text"],
Cell[67017, 1960, 93, 1, 42, "Input"],
Cell[67113, 1963, 81, 1, 42, "Input"],
Cell[67197, 1966, 103, 2, 42, "Input"],
Cell[67303, 1970, 208, 4, 43, "Input"],
Cell[67514, 1976, 5418, 170, 417, "Text"],
Cell[72935, 2148, 61, 0, 42, "Subsection"],
Cell[72999, 2150, 9663, 333, 581, "Text"],
Cell[82665, 2485, 40, 0, 42, "Subsection"],
Cell[82708, 2487, 3647, 113, 253, "Text"],
Cell[86358, 2602, 1531, 48, 114, "Text"],
Cell[87892, 2652, 37, 0, 42, "Subsection"],
Cell[87932, 2654, 2457, 76, 188, "Text"],
Cell[90392, 2732, 84, 1, 42, "Subsection"],
Cell[90479, 2735, 4227, 131, 292, "Text"],
Cell[94709, 2868, 74, 0, 42, "Subsection"],
Cell[94786, 2870, 860, 24, 87, "Text"],
Cell[95649, 2896, 44, 1, 42, "Input"],
Cell[95696, 2899, 10548, 328, 482, "Text"],
Cell[106247, 3229, 143, 2, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[106427, 3236, 90, 2, 53, "Section"],
Cell[106520, 3240, 10885, 345, 512, "Text"],
Cell[117408, 3587, 40, 0, 42, "Subsection"],
Cell[117451, 3589, 4762, 154, 197, "Text"],
Cell[122216, 3745, 70, 0, 42, "Subsection"],
Cell[122289, 3747, 2322, 66, 243, "Body"],
Cell[124614, 3815, 30, 0, 42, "Subsection"],
Cell[124647, 3817, 8967, 280, 355, "Text"],
Cell[133617, 4099, 1078, 30, 120, "Text"],
Cell[134698, 4131, 133, 2, 42, "Input"],
Cell[134834, 4135, 118, 2, 42, "Input"],
Cell[134955, 4139, 141, 2, 42, "Input"],
Cell[135099, 4143, 126, 2, 42, "Input"],
Cell[135228, 4147, 647, 11, 120, "Text"],
Cell[135878, 4160, 62, 0, 42, "Subsection"],
Cell[135943, 4162, 2465, 81, 85, "Text"],
Cell[138411, 4245, 775, 24, 61, "Text"],
Cell[139189, 4271, 53, 0, 42, "Subsection"],
Cell[139245, 4273, 842, 38, 57, "Text"],
Cell[140090, 4313, 68, 0, 42, "Subsection"],
Cell[140161, 4315, 906, 37, 68, "Text"],
Cell[141070, 4354, 40, 0, 42, "Subsection"],
Cell[141113, 4356, 3796, 134, 183, "Text"],
Cell[144912, 4492, 30, 0, 42, "Subsection"],
Cell[144945, 4494, 6133, 166, 82, "Text"],
Cell[151081, 4662, 1877, 56, 64, "Text"],
Cell[152961, 4720, 6001, 167, 90, "Text"],
Cell[158965, 4889, 40, 0, 42, "Subsection"],
Cell[159008, 4891, 9136, 296, 140, "Text"],
Cell[168147, 5189, 407, 12, 57, "Text"],
Cell[168557, 5203, 446, 8, 142, "Input"],
Cell[169006, 5213, 220, 7, 36, "Text"],
Cell[169229, 5222, 78, 1, 42, "Input"],
Cell[169310, 5225, 5513, 151, 206, "Text"],
Cell[174826, 5378, 40, 0, 42, "Subsection"],
Cell[174869, 5380, 980, 27, 200, "Text"],
Cell[175852, 5409, 29, 0, 42, "Subsection"],
Cell[175884, 5411, 325, 13, 36, "Text"],
Cell[176212, 5426, 717, 20, 53, "Text"]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

